/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.claims.ClaimManager;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class ClaimInteractionListener
implements Listener {
    private final boolean protectionLevers = Main.config.getBoolean("claims.protections.interactions.levers");
    private final boolean protectionButtons = Main.config.getBoolean("claims.protections.interactions.buttons");
    private final boolean protectionRepeaters = Main.config.getBoolean("claims.protections.interactions.repeaters");
    private final boolean protectionComparators = Main.config.getBoolean("claims.protections.interactions.comparators");
    private final boolean protectionPressurePlates = Main.config.getBoolean("claims.protections.interactions.pressure-plates");
    private final boolean protectionTrapdoors = Main.config.getBoolean("claims.protections.interactions.trapdoors");
    private final boolean protectionDoors = Main.config.getBoolean("claims.protections.interactions.doors");
    private final boolean protectionFenceGates = Main.config.getBoolean("claims.protections.interactions.fence-gates");
    private final boolean protectionFarmland = Main.config.getBoolean("claims.protections.interactions.farmland");

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        Material type = block.getType();
        Player player = event.getPlayer();
        if (this.isRestrictedInteractable(type) && !ClaimManager.isPlayerAllowed(Main.claimManager, player, block.getLocation())) {
            event.setCancelled(true);
            player.sendActionBar((Component)Component.translatable("messages.claims.not-accessible.interact"));
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (!this.protectionFarmland) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getBlock().getType() == Material.FARMLAND && !ClaimManager.isPlayerAllowed(Main.claimManager, player, event.getBlock().getLocation())) {
            player.sendActionBar((Component)Component.translatable("messages.claims.not-accessible.interact"));
            event.setCancelled(true);
        }
    }

    private boolean isRestrictedInteractable(Material type) {
        String name = type.name();
        if (this.protectionLevers && name.equals("LEVER")) {
            return true;
        }
        if (this.protectionButtons && name.contains("BUTTON")) {
            return true;
        }
        if (this.protectionPressurePlates && name.contains("PRESSURE_PLATE")) {
            return true;
        }
        if (this.protectionRepeaters && name.equals("REPEATER")) {
            return true;
        }
        if (this.protectionComparators && name.equals("COMPARATOR")) {
            return true;
        }
        if (this.protectionTrapdoors && name.contains("TRAPDOOR")) {
            return true;
        }
        if (this.protectionDoors && name.endsWith("_DOOR")) {
            return true;
        }
        return this.protectionFenceGates && name.contains("FENCE_GATE");
    }
}

