/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.endEvent;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.Main;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.player.PlayerPortalEvent;

public class EndListener
implements Listener {
    public static boolean allowEnd = false;
    private static List<String> blockedEntities;

    public static void loadFromConfig() {
        allowEnd = Main.config.getBoolean("end-event.allow-end", false);
        blockedEntities = Main.config.getStringList("end-event.blocked-entities");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityPortal(EntityPortalEvent event) {
        Location location = event.getTo();
        if (!(location instanceof Location)) {
            return;
        }
        Location to = location;
        if (Objects.requireNonNull(to.getWorld()).getEnvironment().equals((Object)World.Environment.THE_END)) {
            return;
        }
        Entity entity = event.getEntity();
        EntityType type = entity.getType();
        if (allowEnd) {
            if (blockedEntities.contains(type.name())) {
                event.setCancelled(true);
            }
        } else {
            event.setCancelled(true);
            if (event instanceof Player) {
                Player player = (Player)event;
                Main.audiences.player(player).sendActionBar(Component.translatable("messages.end-event.closed-message"));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPortal(PlayerPortalEvent event) {
        if (allowEnd) {
            return;
        }
        if (event.getPlayer().hasPermission("buildmc.bypass-end-event")) {
            return;
        }
        Location location = event.getTo();
        if (!(location instanceof Location)) {
            return;
        }
        Location to = location;
        if (Objects.requireNonNull(to.getWorld()).getEnvironment() == World.Environment.THE_END) {
            event.setCancelled(true);
            Main.audiences.player(event.getPlayer()).sendActionBar(Component.translatable("messages.end-event.closed-message"));
        }
    }
}

