/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.spawnElytra;

import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.spawnElytra.ElytraZoneManager;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class SpawnBoostListener
extends BukkitRunnable
implements Listener {
    private final FileConfiguration config;
    private final ElytraZoneManager zoneManager;
    private final int multiplyValue;
    private final boolean boostEnabled;

    public static boolean isUsingSpawnElytra(@NotNull Player player) {
        return player.hasMetadata("uses_spawn_elytra");
    }

    public static boolean isUsingSpawnElytra(@NotNull Entity player) {
        return player.hasMetadata("uses_spawn_elytra");
    }

    public static boolean isPlayerBoosted(@NotNull Player player) {
        return player.hasMetadata("uses_spawn_elytra_boost");
    }

    public static boolean isSurvival(@NotNull Player player) {
        return player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE;
    }

    public static boolean isSurvival(@NotNull GameMode gameMode) {
        return gameMode == GameMode.SURVIVAL || gameMode == GameMode.ADVENTURE;
    }

    public static void stopFlying(@NotNull Player player) {
        player.removeMetadata("uses_spawn_elytra_boost", Main.plugin);
        player.removeMetadata("uses_spawn_elytra", Main.plugin);
        player.setFallDistance(0.0f);
        if (SpawnBoostListener.isSurvival(player)) {
            player.setAllowFlight(false);
        }
        player.setFlying(false);
        player.setGliding(false);
    }

    public static void setPlayerFlying(@NotNull Player player) {
        GameMode mode = player.getGameMode();
        if (!SpawnBoostListener.isSurvival(player)) {
            return;
        }
        player.setGliding(true);
        player.setAllowFlight(false);
        player.setFlying(false);
        player.setMetadata("uses_spawn_elytra", (MetadataValue)new FixedMetadataValue(Main.plugin, null));
    }

    public SpawnBoostListener(ElytraZoneManager zoneManager) {
        this.zoneManager = zoneManager;
        this.config = Main.plugin.getConfig();
        this.multiplyValue = this.config.getInt("spawn-elytra.strength", 2);
        this.boostEnabled = this.config.getBoolean("spawn-elytra.enabled", true);
        this.runTaskTimer(Main.plugin, 0L, 3L);
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!SpawnBoostListener.isSurvival(player)) continue;
            if (SpawnBoostListener.isUsingSpawnElytra(player) && !player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir()) {
                SpawnBoostListener.stopFlying(player);
                continue;
            }
            if (player.isGliding()) continue;
            boolean inZone = this.zoneManager.isInZone(player);
            player.setAllowFlight(inZone);
        }
    }

    @EventHandler
    public void onGamemodeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        GameMode oldMode = player.getGameMode();
        GameMode newMode = event.getNewGameMode();
        if (SpawnBoostListener.isSurvival(oldMode) && !SpawnBoostListener.isSurvival(newMode) && SpawnBoostListener.isUsingSpawnElytra(player)) {
            SpawnBoostListener.stopFlying(player);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.config.getBoolean("spawn-elytra.on-join-elytra-check", true)) {
            return;
        }
        Player player = event.getPlayer();
        SpawnBoostListener.stopFlying(player);
        if (SpawnBoostListener.isSurvival(player)) {
            player.setAllowFlight(false);
        }
    }

    @EventHandler
    public void onDoubleJump(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (!SpawnBoostListener.isSurvival(player)) {
            return;
        }
        if (!this.zoneManager.isInZone(player)) {
            return;
        }
        event.setCancelled(true);
        if (player.isGliding()) {
            return;
        }
        SpawnBoostListener.setPlayerFlying(player);
        if (this.boostEnabled && !SpawnBoostListener.isPlayerBoosted(player)) {
            Main.audiences.player(player).sendActionBar(Message.msg(player, "messages.spawn-elytra.boost-hint"));
        }
    }

    @EventHandler
    public void onSwapItem(PlayerSwapHandItemsEvent event) {
        if (!this.boostEnabled) {
            return;
        }
        Player player = event.getPlayer();
        if (!SpawnBoostListener.isUsingSpawnElytra(player) || SpawnBoostListener.isPlayerBoosted(player)) {
            return;
        }
        event.setCancelled(true);
        player.setMetadata("uses_spawn_elytra_boost", (MetadataValue)new FixedMetadataValue(Main.plugin, null));
        player.setVelocity(player.getLocation().getDirection().multiply(this.multiplyValue).setY(1.2));
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (SpawnBoostListener.isUsingSpawnElytra(player) && (event.getCause() == EntityDamageEvent.DamageCause.FALL || event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onToggleGlide(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (SpawnBoostListener.isUsingSpawnElytra(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityMount(EntityMountEvent event) {
        Entity entity = event.getEntity();
        if (SpawnBoostListener.isUsingSpawnElytra(entity) && entity instanceof Player) {
            Player player = (Player)entity;
            SpawnBoostListener.stopFlying(player);
        }
    }
}

