/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.claims.ClaimDataInstance;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.util.LocationUtil;
import net.mathias2246.buildmc.util.Message;
import net.mathias2246.buildmc.util.Sounds;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimTool
implements Listener {
    @NotNull
    public static final NamespacedKey CLAIM_TOOL_ITEM_PDC_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:is_claim_tool_item"));
    @NotNull
    public static final NamespacedKey REMOVE_TOOL_ITEM_PDC_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:is_remove_tool_item"));
    public static int selectionSizeLimit = 8;
    public static ItemStack claimToolItemstack;
    public static ItemStack removeToolItemstack;
    private static boolean useRightClick;

    public static void setup() {
        ItemMeta m;
        ItemMeta meta;
        useRightClick = Main.config.getBoolean("claims.tool.use-right-instead-of-sneak-click", false);
        Material claimToolItem = Material.getMaterial((String)Main.config.getString("claims.tool.tool-item", "carrot_on_a_stick").toUpperCase());
        if (claimToolItem == null) {
            claimToolItem = Material.CARROT_ON_A_STICK;
        }
        claimToolItemstack = new ItemStack(claimToolItem);
        removeToolItemstack = new ItemStack(claimToolItem);
        selectionSizeLimit = Main.config.getInt("claims.tool.limit-selection", 8);
        if (selectionSizeLimit < 0) {
            selectionSizeLimit = Integer.MAX_VALUE;
        }
        if ((meta = removeToolItemstack.getItemMeta()) != null) {
            meta.setTool(null);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE});
            meta.setUnbreakable(true);
            meta.setRarity(ItemRarity.UNCOMMON);
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            meta.setEnchantable(null);
            meta.getPersistentDataContainer().set(REMOVE_TOOL_ITEM_PDC_KEY, PersistentDataType.BOOLEAN, (Object)true);
            removeToolItemstack.setItemMeta(meta);
        }
        if ((m = claimToolItemstack.getItemMeta()) != null) {
            m.setTool(null);
            m.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE});
            m.setUnbreakable(true);
            m.setRarity(ItemRarity.UNCOMMON);
            m.setEnchantmentGlintOverride(Boolean.valueOf(true));
            m.setEnchantable(null);
            m.getPersistentDataContainer().set(CLAIM_TOOL_ITEM_PDC_KEY, PersistentDataType.BOOLEAN, (Object)true);
            claimToolItemstack.setItemMeta(m);
        }
    }

    public static void giveToolToPlayer(@NotNull Player player) {
        ItemStack i = claimToolItemstack.clone();
        ItemMeta m = i.getItemMeta();
        if (m != null) {
            m.setItemName(LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.tool-name")));
            m.setLore(List.of(LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.tool-tooltip-line1")), LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.tool-tooltip-line2")), LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.tool-tooltip-line3")), LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.tool-tooltip-line4"))));
            i.setItemMeta(m);
        }
        player.getInventory().addItem(new ItemStack[]{i});
    }

    public static void giveRemoveToolToPlayer(@NotNull Player player) {
        ItemStack i = removeToolItemstack.clone();
        ItemMeta m = i.getItemMeta();
        if (m != null) {
            m.setItemName(LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.remove-tool-name")));
            m.setLore(List.of(LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.remove-tool-tooltip-line1")), LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.remove-tool-tooltip-line2")), LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.remove-tool-tooltip-line3")), LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.tool.remove-tool-tooltip-line4"))));
            i.setItemMeta(m);
        }
        player.getInventory().addItem(new ItemStack[]{i});
    }

    public static boolean isClaimTool(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        return pdc.has(CLAIM_TOOL_ITEM_PDC_KEY);
    }

    public static boolean isClaimRemoveTool(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        return pdc.has(REMOVE_TOOL_ITEM_PDC_KEY);
    }

    @EventHandler
    public void onPlayerUseHoe(PlayerInteractEvent event) {
        if (ClaimTool.isClaimTool(event.getItem())) {
            boolean leftClick;
            event.setCancelled(true);
            Player player = event.getPlayer();
            boolean bl = leftClick = event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) || event.getAction().equals((Object)Action.LEFT_CLICK_AIR);
            boolean firstSelection = useRightClick ? leftClick : !player.isSneaking();
            boolean removeBypass = player.hasPermission("buildmc.force-claim");
            Location at = event.getClickedBlock() != null ? event.getClickedBlock().getLocation() : player.getLocation();
            if (player.hasCooldown(event.getItem())) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.tool.tool-cooldown"));
                return;
            }
            if (firstSelection) {
                if (!removeBypass && !ClaimManager.isNotClaimedOrOwn(ClaimManager.getPlayerTeam(player), at)) {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.tool.other-claim-in-selection"));
                    Sounds.playSound(player, Sounds.MISTAKE);
                    return;
                }
                Sounds.playSound(player, Sounds.SUCCESS);
                player.setMetadata("claim_tool_pos1", (MetadataValue)new FixedMetadataValue(Main.plugin, (Object)LocationUtil.serialize(at)));
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.tool.successfully-set-pos"));
                if (!player.hasMetadata("selection_particles")) {
                    player.setMetadata("selection_particles", (MetadataValue)new FixedMetadataValue(Main.plugin, null));
                    new ParticleSpawner(player, false).runTaskTimer(Main.plugin, 0L, 5L);
                }
                player.setCooldown(event.getItem(), 60);
            } else {
                if (!player.hasMetadata("claim_tool_pos1")) {
                    Main.audiences.player(player).sendActionBar(Component.translatable("messages.claims.tool.missing-first-pos"));
                    Sounds.playSound(player, Sounds.MISTAKE);
                    return;
                }
                Team team = ClaimManager.getPlayerTeam(player);
                if (team == null) {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.tool.no-team-to-select"));
                    Sounds.playSound(player, Sounds.MISTAKE);
                    return;
                }
                ClaimTool.tryClaimArea(player, team, LocationUtil.deserialize(((MetadataValue)player.getMetadata("claim_tool_pos1").getFirst()).asString()), at, removeBypass);
            }
        } else if (ClaimTool.isClaimRemoveTool(event.getItem())) {
            boolean leftClick;
            event.setCancelled(true);
            Player player = event.getPlayer();
            boolean bl = leftClick = event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) || event.getAction().equals((Object)Action.LEFT_CLICK_AIR);
            boolean firstSelection = useRightClick ? leftClick : !player.isSneaking();
            boolean removeBypass = player.hasPermission("buildmc.force-claim");
            Location at = event.getClickedBlock() != null ? event.getClickedBlock().getLocation() : player.getLocation();
            if (player.hasCooldown(event.getItem())) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.tool.tool-cooldown"));
                return;
            }
            if (firstSelection) {
                if (!removeBypass && !ClaimManager.isNotClaimedOrOwn(ClaimManager.getPlayerTeam(player), at)) {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.tool.other-claim-in-selection"));
                    Sounds.playSound(player, Sounds.MISTAKE);
                    return;
                }
                Sounds.playSound(player, Sounds.SUCCESS);
                player.setMetadata("claim_tool_pos1", (MetadataValue)new FixedMetadataValue(Main.plugin, (Object)LocationUtil.serialize(at)));
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.tool.successfully-set-pos"));
                if (!player.hasMetadata("selection_particles")) {
                    player.setMetadata("selection_particles", (MetadataValue)new FixedMetadataValue(Main.plugin, null));
                    new ParticleSpawner(player, true).runTaskTimer(Main.plugin, 0L, 5L);
                }
                player.setCooldown(event.getItem(), 60);
            } else {
                if (!player.hasMetadata("claim_tool_pos1")) {
                    Main.audiences.player(player).sendActionBar(Component.translatable("messages.claims.tool.missing-first-pos"));
                    Sounds.playSound(player, Sounds.MISTAKE);
                    return;
                }
                Team team = ClaimManager.getPlayerTeam(player);
                if (team == null) {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.tool.no-team-to-select"));
                    Sounds.playSound(player, Sounds.MISTAKE);
                    return;
                }
                ClaimTool.tryRemoveArea(player, team, LocationUtil.deserialize(((MetadataValue)player.getMetadata("claim_tool_pos1").getFirst()).asString()), at, removeBypass);
            }
        }
    }

    private static void tryRemoveArea(@NotNull Player player, @NotNull Team team, @NotNull Location from, @NotNull Location to, boolean force) {
        int sx = Math.min(from.getChunk().getX(), to.getChunk().getX());
        int sz = Math.min(from.getChunk().getZ(), to.getChunk().getZ());
        int ex = Math.max(from.getChunk().getX(), to.getChunk().getX());
        int ez = Math.max(from.getChunk().getZ(), to.getChunk().getZ());
        World world = from.getWorld();
        if (world == null) {
            return;
        }
        if (ex - sx >= selectionSizeLimit || ez - sz >= selectionSizeLimit) {
            Component m = Message.msg(player, "messages.claims.tool.selection-too-large");
            TextReplacementConfig.Builder r = TextReplacementConfig.builder().matchLiteral("%selection_limit%").replacement(Integer.toString(selectionSizeLimit));
            Main.audiences.player(player).sendMessage(m.replaceText((TextReplacementConfig)r.build()));
            Sounds.playSound(player, Sounds.MISTAKE);
            return;
        }
        int count = 0;
        if (!force) {
            for (int z = sz; z <= ez; ++z) {
                for (int x = sx; x <= ex; ++x) {
                    Chunk chunk = world.getChunkAt(x, z);
                    if (!ClaimManager.isNotClaimedOrOwn(team, chunk)) {
                        Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.tool.other-claim-in-selection"));
                        Sounds.playSound(player, Sounds.MISTAKE);
                        return;
                    }
                    if (!ClaimManager.hasOwner(chunk)) continue;
                    ++count;
                }
            }
        }
        ClaimManager.forceClaimArea(null, world, sx, sz, ex, ez);
        ClaimDataInstance cm = Main.claimManager.getEntryOrNew(team);
        if (cm.chunksLeft >= 0) {
            cm.chunksLeft += count;
        }
        player.removeMetadata("claim_tool_pos1", Main.plugin);
        Sounds.playSound(player, Sounds.SUCCESS);
        Main.audiences.player(player).sendMessage(ClaimTool.buildRemoveSuccessMessage(player, team));
    }

    private static void tryClaimArea(@NotNull Player player, @NotNull Team team, @NotNull Location from, @NotNull Location to, boolean force) {
        int sx = Math.min(from.getChunk().getX(), to.getChunk().getX());
        int sz = Math.min(from.getChunk().getZ(), to.getChunk().getZ());
        int ex = Math.max(from.getChunk().getX(), to.getChunk().getX());
        int ez = Math.max(from.getChunk().getZ(), to.getChunk().getZ());
        World world = from.getWorld();
        if (world == null) {
            return;
        }
        if (ex - sx >= selectionSizeLimit || ez - sz >= selectionSizeLimit) {
            Component m = Message.msg(player, "messages.claims.tool.selection-too-large");
            TextReplacementConfig.Builder r = TextReplacementConfig.builder().matchLiteral("%selection_limit%").replacement(Integer.toString(selectionSizeLimit));
            Main.audiences.player(player).sendMessage(m.replaceText((TextReplacementConfig)r.build()));
            Sounds.playSound(player, Sounds.MISTAKE);
            return;
        }
        int count = 0;
        int chunksLeft = ClaimManager.getChunksLeft(Main.claimManager, team);
        if (!force) {
            for (int z = sz; z <= ez; ++z) {
                for (int x = sx; x <= ex; ++x) {
                    Chunk chunk = world.getChunkAt(x, z);
                    if (!ClaimManager.isNotClaimedOrOwn(team, chunk)) {
                        Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.tool.other-claim-in-selection"));
                        Sounds.playSound(player, Sounds.MISTAKE);
                        return;
                    }
                    if (ClaimManager.hasOwner(chunk) || chunksLeft < 0 || ++count <= chunksLeft) continue;
                    Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.tool.no-chunks-left"));
                    Sounds.playSound(player, Sounds.MISTAKE);
                    return;
                }
            }
        }
        ClaimManager.forceClaimArea(team, world, sx, sz, ex, ez);
        if (chunksLeft > 0) {
            Main.claimManager.getEntryOrNew((Team)team).chunksLeft -= count;
        }
        player.removeMetadata("claim_tool_pos1", Main.plugin);
        Sounds.playSound(player, Sounds.SUCCESS);
        Main.audiences.player(player).sendMessage(ClaimTool.buildSuccessMessage(player, team));
    }

    private static Component buildSuccessMessage(@NotNull Player player, @NotNull Team team) {
        int i = ClaimManager.getChunksLeft(Main.claimManager, team);
        if (i < 0) {
            return Component.translatable("messages.claims.tool.successfully-claimed-area-no-count");
        }
        TextReplacementConfig.Builder r = TextReplacementConfig.builder().matchLiteral("%chunks_left%").replacement(Integer.toString(i));
        return Message.msg(player, "messages.claims.tool.successfully-claimed-area").replaceText((TextReplacementConfig)r.build());
    }

    private static Component buildRemoveSuccessMessage(@NotNull Player player, @NotNull Team team) {
        int i = ClaimManager.getChunksLeft(Main.claimManager, team);
        if (i < 0) {
            return Component.translatable("messages.claims.tool.successfully-removed-area-no-count");
        }
        TextReplacementConfig.Builder r = TextReplacementConfig.builder().matchLiteral("%chunks_left%").replacement(Integer.toString(i));
        return Message.msg(player, "messages.claims.tool.successfully-removed-area").replaceText((TextReplacementConfig)r.build());
    }

    static {
        useRightClick = false;
    }

    public static class ParticleSpawner
    extends BukkitRunnable {
        @NotNull
        public final Player source;
        private int repeat = 32;
        private final Location plane;
        private final Location l1;
        private final Location l2;
        private final Location l3;
        private final Location l4;
        public final Particle.DustOptions chunkPlane;
        public final Particle.DustOptions corner;

        public ParticleSpawner(@NotNull Player source, boolean isRemoveSelection) {
            this.source = source;
            this.plane = LocationUtil.deserialize(((MetadataValue)source.getMetadata("claim_tool_pos1").getFirst()).asString());
            Chunk c = this.plane.getChunk();
            this.plane.setX((double)((c.getX() << 4) + 8));
            this.plane.setZ((double)((c.getZ() << 4) + 8));
            this.plane.setY(this.plane.getY() + 1.5);
            this.l1 = new Location(source.getWorld(), (double)(source.getLocation().getChunk().getX() << 4) + 0.5, this.plane.getY(), (double)(source.getLocation().getChunk().getZ() << 4) + 0.5);
            this.l2 = new Location(source.getWorld(), (double)(source.getLocation().getChunk().getX() << 4) + 15.5, this.plane.getY(), (double)(source.getLocation().getChunk().getZ() << 4) + 0.0);
            this.l3 = new Location(source.getWorld(), (double)(source.getLocation().getChunk().getX() << 4) + 0.0, this.plane.getY(), (double)(source.getLocation().getChunk().getZ() << 4) + 15.5);
            this.l4 = new Location(source.getWorld(), (double)(source.getLocation().getChunk().getX() << 4) + 15.5, this.plane.getY(), (double)(source.getLocation().getChunk().getZ() << 4) + 15.5);
            this.chunkPlane = isRemoveSelection ? new Particle.DustOptions(Color.fromRGB((int)210, (int)10, (int)10), 1.0f) : new Particle.DustOptions(Color.fromRGB((int)10, (int)230, (int)10), 1.0f);
            this.corner = new Particle.DustOptions(Color.fromRGB((int)10, (int)10, (int)230), 1.0f);
        }

        public void run() {
            if (this.repeat < 0 || !this.source.hasMetadata("selection_particles")) {
                this.source.removeMetadata("selection_particles", Main.plugin);
                this.cancel();
            }
            --this.repeat;
            Class p = Particle.DUST.getDataType();
            this.source.spawnParticle(Particle.DUST, this.plane, 100, 2.6, 0.0, 2.6, (Object)this.chunkPlane);
            this.source.spawnParticle(Particle.DUST, this.l1, 100, 0.0, 1.0, 0.0, (Object)this.corner);
            this.source.spawnParticle(Particle.DUST, this.l2, 100, 0.0, 1.0, 0.0, (Object)this.corner);
            this.source.spawnParticle(Particle.DUST, this.l3, 100, 0.0, 1.0, 0.0, (Object)this.corner);
            this.source.spawnParticle(Particle.DUST, this.l4, 100, 0.0, 1.0, 0.0, (Object)this.corner);
        }
    }
}

