/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.io.IOException;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.claims.ClaimTool;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public class ClaimCommand
implements CustomCommand {
    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        LiteralArgumentBuilder cmd = Commands.literal((String)"claim");
        cmd.then(Commands.literal((String)"claimtool").executes(command -> {
            Entity patt0$temp = ((CommandSourceStack)command.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.error.not-a-player"));
                return 0;
            }
            Player player = (Player)patt0$temp;
            if (player.getInventory().firstEmpty() == -1) {
                player.sendMessage((Component)Component.translatable("messages.claims.tool.full-inventory"));
                return 0;
            }
            ClaimTool.giveToolToPlayer(player);
            player.sendMessage((Component)Component.translatable("messages.claims.tool.give-success"));
            return 1;
        }));
        cmd.then(Commands.literal((String)"removetool").executes(command -> {
            Entity patt0$temp = ((CommandSourceStack)command.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.error.not-a-player"));
                return 0;
            }
            Player player = (Player)patt0$temp;
            if (player.getInventory().firstEmpty() == -1) {
                player.sendMessage((Component)Component.translatable("messages.claims.tool.full-inventory"));
                return 0;
            }
            ClaimTool.giveRemoveToolToPlayer(player);
            player.sendMessage((Component)Component.translatable("messages.claims.tool.give-success"));
            return 1;
        }));
        cmd.then(Commands.literal((String)"who").executes(command -> {
            CommandSender patt0$temp = ((CommandSourceStack)command.getSource()).getSender();
            if (!(patt0$temp instanceof Player)) {
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.error.not-a-player"));
                return 0;
            }
            Player player = (Player)patt0$temp;
            String owner = ClaimManager.getOwnerString(player.getLocation());
            if (owner == null) {
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.claims.who.unclaimed"));
                return 1;
            }
            Component message = Message.msg(player, "messages.claims.who.message");
            TextReplacementConfig.Builder b = TextReplacementConfig.builder();
            b.matchLiteral("%owner%");
            b.replacement(owner);
            ((CommandSourceStack)command.getSource()).getSender().sendMessage(message.replaceText((TextReplacementConfig)b.build()));
            return 1;
        }));
        cmd.then(Commands.literal((String)"help").executes(command -> {
            CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
            sender.sendMessage((Component)Component.translatable("messages.claims.help-message"));
            return 1;
        }));
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"whitelist").then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(command -> {
            CommandSender patt0$temp = ((CommandSourceStack)command.getSource()).getSender();
            if (!(patt0$temp instanceof Player)) {
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.error.not-a-player"));
                return 0;
            }
            Player player = (Player)patt0$temp;
            Team team = ClaimManager.getPlayerTeam(player);
            if (team == null) {
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.error.not-in-a-team"));
                return 0;
            }
            PlayerSelectorArgumentResolver ps = command.getArgument("player", PlayerSelectorArgumentResolver.class);
            for (Player p : (List)ps.resolve((CommandSourceStack)command.getSource())) {
                if (ClaimManager.isPlayerWhitelisted(Main.claimManager, team, p)) {
                    ((CommandSourceStack)command.getSource()).getSender().sendMessage(Component.translatable("messages.claims.already-whitelisted").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%player%").replacement(p.getName()).build()));
                    continue;
                }
                ClaimManager.setPlayerWhitelisted(Main.claimManager, team, p);
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.claims.successfully-whitelisted"));
            }
            try {
                Main.claimManager.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 1;
        })))).then(Commands.literal((String)"remove").then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(command -> {
            CommandSender patt0$temp = ((CommandSourceStack)command.getSource()).getSender();
            if (!(patt0$temp instanceof Player)) {
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.error.not-a-player"));
                return 0;
            }
            Player player = (Player)patt0$temp;
            Team team = ClaimManager.getPlayerTeam(player);
            if (team == null) {
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.error.not-in-a-team"));
                return 0;
            }
            PlayerSelectorArgumentResolver ps = command.getArgument("player", PlayerSelectorArgumentResolver.class);
            for (Player p : (List)ps.resolve((CommandSourceStack)command.getSource())) {
                ClaimManager.removePlayerWhitelisted(Main.claimManager, team, p);
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.claims.successfully-removed-whitelisted"));
            }
            try {
                Main.claimManager.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 1;
        }))));
        return cmd.build();
    }
}

