/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.spawnElytra;

import java.io.IOException;
import java.util.Objects;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ElytraZoneManager {
    private Location pos1;
    private Location pos2;
    private BoundingBox boundingBox;
    private World world;

    public void setPos1(@NotNull Player player, @NotNull Location loc) {
        this.pos1 = loc;
        player.sendMessage(Message.msg(player, "messages.spawn-elytra.pos1-set"));
        this.tryCreateZone(player);
    }

    public void setPos2(@NotNull Player player, @NotNull Location loc) {
        this.pos2 = loc;
        player.sendMessage(Message.msg(player, "messages.spawn-elytra.pos2-set"));
        this.tryCreateZone(player);
    }

    private void tryCreateZone(@NotNull Player player) {
        if (this.pos1 == null || this.pos2 == null) {
            return;
        }
        if (!Objects.equals(this.pos1.getWorld(), this.pos2.getWorld())) {
            player.sendMessage(Message.msg(player, "messages.spawn-elytra.error.different-worlds"));
            return;
        }
        this.boundingBox = BoundingBox.of((Vector)this.pos1.toVector(), (Vector)this.pos2.toVector());
        this.world = this.pos1.getWorld();
        this.saveZoneToConfig();
        player.sendMessage(Message.msg(player, "messages.spawn-elytra.success"));
    }

    public boolean isInZone(@NotNull Player player) {
        if (this.boundingBox == null || this.world == null) {
            return false;
        }
        Location loc = player.getLocation();
        return this.world.equals((Object)loc.getWorld()) && this.boundingBox.contains(loc.toVector());
    }

    private void saveZoneToConfig() {
        Main.config.set("spawn-elytra.zone.world", (Object)this.world.getName());
        Main.config.set("spawn-elytra.zone.pos1.x", (Object)this.pos1.getX());
        Main.config.set("spawn-elytra.zone.pos1.y", (Object)this.pos1.getY());
        Main.config.set("spawn-elytra.zone.pos1.z", (Object)this.pos1.getZ());
        Main.config.set("spawn-elytra.zone.pos2.x", (Object)this.pos2.getX());
        Main.config.set("spawn-elytra.zone.pos2.y", (Object)this.pos2.getY());
        Main.config.set("spawn-elytra.zone.pos2.z", (Object)this.pos2.getZ());
        try {
            Main.config.save(Main.configFile);
        }
        catch (IOException e) {
            Main.logger.warning("Failed to save config file: " + e.getMessage());
        }
    }

    public void loadZoneFromConfig() {
        String worldName = Main.config.getString("spawn-elytra.zone.world");
        if (worldName == null) {
            return;
        }
        this.world = Bukkit.getWorld((String)worldName);
        if (this.world == null) {
            Main.logger.warning("ElytraZoneManager: World '" + worldName + "' not found.");
            return;
        }
        try {
            double x1 = Main.config.getDouble("spawn-elytra.zone.pos1.x");
            double y1 = Main.config.getDouble("spawn-elytra.zone.pos1.y");
            double z1 = Main.config.getDouble("spawn-elytra.zone.pos1.z");
            double x2 = Main.config.getDouble("spawn-elytra.zone.pos2.x");
            double y2 = Main.config.getDouble("spawn-elytra.zone.pos2.y");
            double z2 = Main.config.getDouble("spawn-elytra.zone.pos2.z");
            this.pos1 = new Location(this.world, x1, y1, z1);
            this.pos2 = new Location(this.world, x2, y2, z2);
            this.boundingBox = BoundingBox.of((Vector)this.pos1.toVector(), (Vector)this.pos2.toVector());
        }
        catch (Exception e) {
            Main.logger.warning("ElytraZoneManager: Failed to load elytra zone from config: " + e.getMessage());
        }
    }
}

