/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.api.item;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.mathias2246.buildmc.api.item.AbstractCustomItem;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomItemRegistry
implements Registry<AbstractCustomItem> {
    private final Map<NamespacedKey, AbstractCustomItem> items = new LinkedHashMap<NamespacedKey, AbstractCustomItem>();

    public void register(@NotNull AbstractCustomItem item) throws IllegalArgumentException {
        NamespacedKey key = item.getKey();
        if (this.items.containsKey(key)) {
            throw new IllegalArgumentException("Custom item with key " + String.valueOf(key) + " is already registered.");
        }
        this.items.put(key, item);
    }

    public void tryRegister(@NotNull AbstractCustomItem item) {
        NamespacedKey key = item.getKey();
        if (this.items.containsKey(key)) {
            return;
        }
        this.items.put(key, item);
    }

    @Nullable
    public AbstractCustomItem get(@Nullable NamespacedKey namespacedKey) {
        if (namespacedKey == null) {
            return null;
        }
        return this.items.get(namespacedKey);
    }

    @Nullable
    public AbstractCustomItem getFromItemStack(@Nullable ItemStack item) {
        return this.get(AbstractCustomItem.getCustomItemKey(item));
    }

    @NotNull
    public AbstractCustomItem getOrThrow(@NotNull NamespacedKey namespacedKey) throws IllegalArgumentException {
        AbstractCustomItem item = this.items.get(namespacedKey);
        if (item == null) {
            throw new IllegalArgumentException("No custom item registered for key " + String.valueOf(namespacedKey));
        }
        return item;
    }

    @NotNull
    public Stream<AbstractCustomItem> stream() {
        return this.items.values().stream();
    }

    @NotNull
    public Iterator<AbstractCustomItem> iterator() {
        return this.items.values().iterator();
    }

    public boolean contains(@NotNull NamespacedKey key) {
        return this.items.containsKey(key);
    }

    public int size() {
        return this.items.size();
    }
}

