/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.api.item.abstractTypes;

import java.util.List;
import java.util.Objects;
import net.mathias2246.buildmc.api.item.abstractTypes.AbstractTool;
import net.mathias2246.buildmc.util.LocationUtil;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSelectionTool
extends AbstractTool {
    @NotNull
    public static final NamespacedKey SELECTION_TOOL_COOLDOWN_GROUP = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:selection_tool_cooldown"));
    @NotNull
    public final String firstSelectionKey;
    @NotNull
    public final String secondSelectionKey;

    public AbstractSelectionTool(@NotNull Plugin plugin, @NotNull NamespacedKey key) {
        super(plugin, key);
        this.firstSelectionKey = String.valueOf(key) + "_first_selection";
        this.secondSelectionKey = String.valueOf(key) + "_second_selection";
    }

    @Override
    public abstract boolean canUse(@NotNull ItemStack var1, @NotNull PlayerInteractEvent var2);

    @Override
    protected void onInteract(@NotNull ItemStack item, @NotNull PlayerInteractEvent event) {
        event.setCancelled(true);
    }

    @Override
    protected void onLeftClick(@NotNull ItemStack item, @NotNull Location at, @NotNull PlayerInteractEvent event) {
        if (!this.canUse(item, event)) {
            return;
        }
        if (!this.allowFirstSelection(item, at, event)) {
            return;
        }
        event.getPlayer().setMetadata(this.firstSelectionKey, (MetadataValue)new FixedMetadataValue(this.getPlugin(), (Object)LocationUtil.serialize(at)));
        this.onSuccessfulFirstSelection(item, at, event);
    }

    @Nullable
    public Location getFirstSelection(@NotNull Player player) {
        List l = player.getMetadata(this.firstSelectionKey);
        if (l.isEmpty()) {
            return null;
        }
        return LocationUtil.tryDeserialize(((MetadataValue)l.getFirst()).asString());
    }

    @Nullable
    public Location getSecondSelection(@NotNull Player player) {
        List l = player.getMetadata(this.secondSelectionKey);
        if (l.isEmpty()) {
            return null;
        }
        return LocationUtil.tryDeserialize(((MetadataValue)l.getFirst()).asString());
    }

    @Override
    protected void onRightClick(@NotNull ItemStack item, @NotNull Location at, @NotNull PlayerInteractEvent event) {
        if (!this.canUse(item, event)) {
            return;
        }
        if (!this.allowSecondSelection(item, at, event)) {
            return;
        }
        event.getPlayer().setMetadata(this.secondSelectionKey, (MetadataValue)new FixedMetadataValue(this.getPlugin(), (Object)LocationUtil.serialize(at)));
        this.onSuccessfulSecondSelection(item, at, event);
    }

    public abstract boolean allowFirstSelection(@NotNull ItemStack var1, @NotNull Location var2, @NotNull PlayerInteractEvent var3);

    public abstract boolean allowSecondSelection(@NotNull ItemStack var1, @NotNull Location var2, @NotNull PlayerInteractEvent var3);

    public abstract void onSuccessfulFirstSelection(@NotNull ItemStack var1, @NotNull Location var2, @NotNull PlayerInteractEvent var3);

    public abstract void onSuccessfulSecondSelection(@NotNull ItemStack var1, @NotNull Location var2, @NotNull PlayerInteractEvent var3);
}

