/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.protections.misc;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.item.ItemUtil;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.type.util.Gui;
import net.mathias2246.buildmc.ui.UIUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lectern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Containers
extends Protection {
    public Containers(@Nullable ConfigurationSection section) {
        super(Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:containers")), section != null ? section.getBoolean("default", true) : true, section != null && section.getBoolean("is-hidden", false));
    }

    @Override
    public String getTranslationBaseKey() {
        return "claims.flags.container";
    }

    @Override
    @NotNull
    public GuiItem getDisplay(@NotNull Player uiHolder, @NotNull Gui gui) {
        String t = this.getTranslationBaseKey();
        ItemStack displayBase = new ItemStack(Material.CHEST);
        ItemUtil.editMeta(displayBase, meta -> {
            meta.setItemName(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".name")));
            meta.setLore(List.of(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".lore")).split("\n")));
        });
        return new GuiItem(displayBase, UIUtil.noInteract);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onOpenContainer(InventoryOpenEvent event) {
        Claim claim;
        Player player = (Player)event.getPlayer();
        Location loc = event.getInventory().getLocation();
        if (loc == null) {
            return;
        }
        try {
            claim = ClaimManager.getClaim(loc);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("SQL error while getting claim: " + String.valueOf(e));
            return;
        }
        if (claim == null) {
            return;
        }
        if (claim.getWhitelistedPlayers().contains(player.getUniqueId())) {
            return;
        }
        InventoryType invType = event.getInventory().getType();
        if (event.getInventory().getHolder() instanceof Lectern) {
            return;
        }
        if (invType.equals((Object)InventoryType.ENDER_CHEST)) {
            return;
        }
        if (invType.equals((Object)InventoryType.WORKBENCH)) {
            return;
        }
        if (invType.equals((Object)InventoryType.ENCHANTING)) {
            return;
        }
        if (invType.equals((Object)InventoryType.SMITHING)) {
            return;
        }
        if (invType.equals((Object)InventoryType.LOOM)) {
            return;
        }
        if (invType.equals((Object)InventoryType.CARTOGRAPHY)) {
            return;
        }
        if (invType.equals((Object)InventoryType.GRINDSTONE)) {
            return;
        }
        if (invType.equals((Object)InventoryType.STONECUTTER)) {
            return;
        }
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof BlockState) {
            BlockState block = (BlockState)inventoryHolder;
            if (!ClaimManager.isPlayerAllowed(player, this.getKey(), claim)) {
                CoreMain.mainClass.sendPlayerActionBar(player, Component.translatable("messages.claims.not-accessible.container"));
                event.setCancelled(true);
            }
        } else {
            inventoryHolder = event.getInventory().getHolder();
            if (inventoryHolder instanceof Entity) {
                Entity entity = (Entity)inventoryHolder;
                if (!ClaimManager.isPlayerAllowed(player, this.getKey(), claim)) {
                    CoreMain.mainClass.sendPlayerActionBar(player, Component.translatable("messages.claims.not-accessible.entity-container"));
                    event.setCancelled(true);
                }
            } else if (!ClaimManager.isPlayerAllowed(player, this.getKey(), claim)) {
                CoreMain.mainClass.sendPlayerActionBar(player, Component.translatable("messages.claims.not-accessible.container"));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onLecternTakeBook(PlayerTakeLecternBookEvent event) {
        Claim claim;
        Lectern block = event.getLectern();
        Player player = event.getPlayer();
        try {
            claim = ClaimManager.getClaim(block.getLocation());
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("SQL error while getting claim: " + String.valueOf(e));
            return;
        }
        if (claim == null) {
            return;
        }
        if (!ClaimManager.isPlayerAllowed(player, this.getKey(), claim)) {
            event.setCancelled(true);
            CoreMain.mainClass.sendPlayerActionBar(player, Component.translatable("messages.claims.not-accessible.interact"));
        }
    }
}

