/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.commandAPI.arguments;

import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.mathias2246.buildmc.commandAPI.arguments.CommandAPIArgumentType;
import net.mathias2246.buildmc.commandAPI.arguments.SafeOverrideableArgument;
import net.mathias2246.buildmc.commandAPI.exceptions.InvalidRangeException;
import net.mathias2246.buildmc.commandAPI.executors.CommandArguments;

public class DoubleArgument
extends SafeOverrideableArgument<Double, Double> {
    public DoubleArgument(String nodeName) {
        super(nodeName, DoubleArgumentType.doubleArg(), String::valueOf);
    }

    public DoubleArgument(String nodeName, double min) {
        super(nodeName, DoubleArgumentType.doubleArg(min), String::valueOf);
    }

    public DoubleArgument(String nodeName, double min, double max) {
        super(nodeName, DoubleArgumentType.doubleArg(min, max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Double> getPrimitiveType() {
        return Double.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_DOUBLE;
    }

    @Override
    public <Source> Double parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

