/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.endEvent;

import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.api.endEvent.EndChangeCause;
import net.mathias2246.buildmc.api.endEvent.EndState;
import net.mathias2246.buildmc.api.event.endevent.EndStateChangeEvent;
import net.mathias2246.buildmc.commandAPI.CommandAPICommand;
import net.mathias2246.buildmc.commandAPI.executors.ExecutorType;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.endEvent.EndListener;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class EndEventCommand
implements CustomCommand {
    @Override
    public CommandAPICommand getCommand() {
        return ((CommandAPICommand)new CommandAPICommand("endevent").withPermission("buildmc.admin")).withSubcommand(this.getSubCommand("open", true)).withSubcommand(this.getSubCommand("close", false));
    }

    private CommandAPICommand getSubCommand(String name, boolean allowEnd) {
        return (CommandAPICommand)new CommandAPICommand(name).executes(command -> {
            CommandSender sender = (CommandSender)command.sender();
            String openAnnouncementKey = "messages.end-event.broadcast-opened";
            String closeAnnouncementKey = "messages.end-event.broadcast-closed";
            EndState newState = allowEnd ? EndState.OPEN : EndState.CLOSED;
            EndState prevState = EndListener.allowEnd ? EndState.OPEN : EndState.CLOSED;
            String messageKey = allowEnd ? openAnnouncementKey : closeAnnouncementKey;
            EndStateChangeEvent event = new EndStateChangeEvent(newState, prevState, EndChangeCause.COMMAND, sender, messageKey);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            messageKey = event.getAnnouncementKey();
            EndListener.allowEnd = allowEnd;
            Main.config.set("end-event.allow-end", (Object)allowEnd);
            try {
                Main.config.save(Main.configFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String senderMessageKey = allowEnd ? "messages.end-event.opened" : "messages.end-event.closed";
            TranslatableComponent senderMessage = Component.translatable(senderMessageKey);
            Main.audiences.sender((CommandSender)command.sender()).sendMessage(senderMessage);
            for (Player player : Bukkit.getOnlinePlayers()) {
                TranslatableComponent msg = Component.translatable(messageKey);
                Main.audiences.player(player).sendMessage(msg);
            }
        }, new ExecutorType[0]);
    }
}

