/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import net.mathias2246.buildmc.inventoryframework.gui.type.MerchantGui;
import net.mathias2246.buildmc.inventoryframework.gui.type.util.Gui;
import net.mathias2246.buildmc.inventoryframework.util.InventoryViewUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiListener
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Set<Gui> activeGuiInstances = new HashSet<Gui>();

    public GuiListener(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(@NotNull InventoryClickEvent event) {
        Gui gui = this.getGui(event.getInventory());
        if (gui == null) {
            return;
        }
        InventoryView view = event.getView();
        Inventory inventory = InventoryViewUtil.getInstance().getInventory(view, event.getRawSlot());
        if (inventory == null) {
            gui.callOnOutsideClick(event);
            return;
        }
        gui.callOnGlobalClick(event);
        if (inventory.equals((Object)InventoryViewUtil.getInstance().getTopInventory(view))) {
            gui.callOnTopClick(event);
        } else {
            gui.callOnBottomClick(event);
        }
        gui.click(event);
        if (event.isCancelled()) {
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                PlayerInventory playerInventory = event.getWhoClicked().getInventory();
                playerInventory.setItemInOffHand(playerInventory.getItemInOffHand());
            });
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityPickupItem(@NotNull EntityPickupItemEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof HumanEntity)) {
            return;
        }
        Gui gui = this.getGui(InventoryViewUtil.getInstance().getTopInventory(((HumanEntity)entity).getOpenInventory()));
        if (gui == null || !gui.isPlayerInventoryUsed()) {
            return;
        }
        int leftOver = gui.getHumanEntityCache().add((HumanEntity)entity, event.getItem().getItemStack());
        if (leftOver == 0) {
            event.getItem().remove();
        } else {
            ItemStack itemStack = event.getItem().getItemStack();
            itemStack.setAmount(leftOver);
            event.getItem().setItemStack(itemStack);
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onInventoryDrag(@NotNull InventoryDragEvent event) {
        Gui gui = this.getGui(event.getInventory());
        if (gui == null) {
            return;
        }
        InventoryView view = event.getView();
        Set inventorySlots = event.getRawSlots();
        if (inventorySlots.size() > 1) {
            boolean top = false;
            boolean bottom = false;
            Iterator iterator = inventorySlots.iterator();
            while (iterator.hasNext()) {
                int inventorySlot = (Integer)iterator.next();
                Inventory inventory = InventoryViewUtil.getInstance().getInventory(view, inventorySlot);
                if (InventoryViewUtil.getInstance().getTopInventory(view).equals((Object)inventory)) {
                    top = true;
                } else if (InventoryViewUtil.getInstance().getBottomInventory(view).equals((Object)inventory)) {
                    bottom = true;
                }
                if (!top || !bottom) continue;
                break;
            }
            gui.callOnGlobalDrag(event);
            if (top) {
                gui.callOnTopDrag(event);
            }
            if (bottom) {
                gui.callOnBottomDrag(event);
            }
        } else {
            int index = inventorySlots.toArray(new Integer[0])[0];
            InventoryType.SlotType slotType = InventoryViewUtil.getInstance().getSlotType(view, index);
            boolean even = event.getType() == DragType.EVEN;
            ClickType clickType = even ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction inventoryAction = even ? InventoryAction.PLACE_SOME : InventoryAction.PLACE_ONE;
            ItemStack previousViewCursor = InventoryViewUtil.getInstance().getCursor(view);
            InventoryViewUtil.getInstance().setCursor(view, event.getOldCursor());
            InventoryClickEvent inventoryClickEvent = new InventoryClickEvent(view, slotType, index, clickType, inventoryAction);
            this.onInventoryClick(inventoryClickEvent);
            if (Objects.equals(InventoryViewUtil.getInstance().getCursor(view), event.getOldCursor())) {
                InventoryViewUtil.getInstance().setCursor(view, previousViewCursor);
            }
            event.setCancelled(inventoryClickEvent.isCancelled());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTradeSelect(@NotNull TradeSelectEvent event) {
        Gui gui = this.getGui((Inventory)event.getInventory());
        if (!(gui instanceof MerchantGui)) {
            return;
        }
        ((MerchantGui)gui).callOnTradeSelect(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Gui gui = this.getGui(event.getInventory());
        if (gui == null) {
            return;
        }
        HumanEntity humanEntity = event.getPlayer();
        PlayerInventory playerInventory = humanEntity.getInventory();
        playerInventory.setItemInOffHand(playerInventory.getItemInOffHand());
        gui.callOnClose(event);
        gui.getHumanEntityCache().restoreAndForget(humanEntity);
        if (gui.getViewerCount() == 1) {
            this.activeGuiInstances.remove(gui);
        }
        Bukkit.getScheduler().runTask(this.plugin, () -> gui.navigateToParent(humanEntity));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        Gui gui = this.getGui(event.getInventory());
        if (gui == null) {
            return;
        }
        this.activeGuiInstances.add(gui);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPluginDisable(@NotNull PluginDisableEvent event) {
        if (event.getPlugin() != this.plugin) {
            return;
        }
        int counter = 0;
        int maxCount = 10;
        while (!this.activeGuiInstances.isEmpty() && counter++ < maxCount) {
            for (Gui gui : new ArrayList<Gui>(this.activeGuiInstances)) {
                for (HumanEntity viewer : gui.getViewers()) {
                    viewer.closeInventory();
                }
            }
        }
        if (counter == maxCount) {
            Logger logger = this.plugin.getLogger();
            logger.warning("Unable to close GUIs on plugin disable: they keep getting opened (tried: " + maxCount + " times)");
        }
    }

    @Nullable
    @Contract(pure=true)
    private Gui getGui(@NotNull Inventory inventory) {
        Gui gui = Gui.getGui(inventory);
        if (gui != null) {
            return gui;
        }
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof Gui) {
            return (Gui)holder;
        }
        return null;
    }
}

