/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.nms.v1_21_4;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mathias2246.buildmc.inventoryframework.adventuresupport.TextHolder;
import net.mathias2246.buildmc.inventoryframework.nms.v1_21_4.util.TextHolderUtil;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.npc.MerchantWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.InventoryMerchant;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftInventoryMerchant;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.inventory.view.CraftMerchantView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MerchantInventoryImpl
extends net.mathias2246.buildmc.inventoryframework.abstraction.MerchantInventory {
    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory(@NotNull TextHolder title) {
        MerchantWrapper merchant = new MerchantWrapper(null);
        final InventoryViewProvider container = new InventoryViewProvider((IMerchant)merchant, (IMerchant)merchant, title){
            final /* synthetic */ IMerchant val$merchant;
            final /* synthetic */ TextHolder val$title;
            {
                this.val$merchant = iMerchant;
                this.val$title = textHolder;
                super(merchant);
            }

            @NotNull
            @Contract(pure=true)
            public Container createMenu(int containerId, @Nullable PlayerInventory inventory, @NotNull EntityHuman player) {
                return new ContainerMerchantImpl(containerId, player, this, this.val$merchant);
            }

            @NotNull
            @Contract(pure=true)
            public IChatBaseComponent p_() {
                return TextHolderUtil.toComponent(this.val$title);
            }
        };
        return new CraftInventoryMerchant((IMerchant)merchant, container){

            @NotNull
            @Contract(pure=true)
            public InventoryType getType() {
                return InventoryType.MERCHANT;
            }

            public InventoryMerchant getInventory() {
                return container;
            }
        };
    }

    @Override
    public void sendMerchantOffers(@NotNull Player player, @NotNull List<? extends Map.Entry<? extends org.bukkit.inventory.MerchantRecipe, ? extends Integer>> trades, int level, int experience) {
        MerchantRecipeList offers = new MerchantRecipeList();
        for (Map.Entry<? extends org.bukkit.inventory.MerchantRecipe, ? extends Integer> entry : trades) {
            org.bukkit.inventory.MerchantRecipe recipe = entry.getKey();
            List ingredients = recipe.getIngredients();
            if (ingredients.size() < 1) {
                throw new IllegalStateException("Merchant recipe has no ingredients");
            }
            ItemStack itemA = (ItemStack)ingredients.get(0);
            ItemStack itemB = null;
            if (ingredients.size() >= 2) {
                itemB = (ItemStack)ingredients.get(1);
            }
            net.minecraft.world.item.ItemStack nmsItemA = CraftItemStack.asNMSCopy((ItemStack)itemA);
            net.minecraft.world.item.ItemStack nmsItemB = net.minecraft.world.item.ItemStack.j;
            net.minecraft.world.item.ItemStack nmsItemResult = CraftItemStack.asNMSCopy((ItemStack)recipe.getResult());
            if (itemB != null) {
                nmsItemB = CraftItemStack.asNMSCopy((ItemStack)itemB);
            }
            ItemCost itemCostA = this.convertItemStackToItemCost(nmsItemA);
            ItemCost itemCostB = this.convertItemStackToItemCost(nmsItemB);
            int uses = recipe.getUses();
            int maxUses = recipe.getMaxUses();
            int exp = recipe.getVillagerExperience();
            float multiplier = recipe.getPriceMultiplier();
            MerchantRecipe merchantOffer = new MerchantRecipe(itemCostA, Optional.of(itemCostB), nmsItemResult, uses, maxUses, exp, multiplier);
            merchantOffer.b(entry.getValue().intValue());
            offers.add((Object)merchantOffer);
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int n = this.getContainerId((EntityHuman)serverPlayer);
        serverPlayer.a(n, offers, level, experience, true, false);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    private ItemCost convertItemStackToItemCost(@NotNull net.minecraft.world.item.ItemStack itemStack) {
        DataComponentPredicate predicate = DataComponentPredicate.a((DataComponentMap)itemStack.a());
        return new ItemCost(itemStack.i(), itemStack.M(), predicate, itemStack);
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.cd.l;
    }

    private static class ContainerMerchantImpl
    extends ContainerMerchant {
        @NotNull
        private final HumanEntity humanEntity;
        @NotNull
        private final InventoryMerchant container;
        @NotNull
        private final IMerchant merchant;
        @Nullable
        private CraftMerchantView bukkitEntity;

        public ContainerMerchantImpl(int containerId, @NotNull EntityHuman player, @NotNull InventoryMerchant container, @NotNull IMerchant merchant) {
            super(containerId, player.gi(), merchant);
            this.humanEntity = player.getBukkitEntity();
            this.container = container;
            this.merchant = merchant;
            this.checkReachable = false;
            this.updateSlot(0, (IInventory)container);
            this.updateSlot(1, (IInventory)container);
            Slot slot = (Slot)this.k.get(2);
            Slot newSlot = new Slot((IInventory)container, slot.a, slot.e, slot.f){

                @Contract(value="_ -> false", pure=true)
                public boolean a(@Nullable EntityHuman player) {
                    return false;
                }

                @Contract(value="_ -> false", pure=true)
                public boolean a(@Nullable net.minecraft.world.item.ItemStack itemStack) {
                    return false;
                }
            };
            newSlot.d = slot.d;
            this.k.set(2, (Object)newSlot);
        }

        @NotNull
        public CraftMerchantView getBukkitView() {
            if (this.bukkitEntity != null) {
                return this.bukkitEntity;
            }
            CraftInventoryMerchant inventory = new CraftInventoryMerchant(this.merchant, this.container);
            this.bukkitEntity = new CraftMerchantView(this.humanEntity, (MerchantInventory)inventory, (ContainerMerchant)this, this.merchant);
            return this.bukkitEntity;
        }

        public void a(@Nullable IInventory container) {
        }

        public void a(@Nullable EntityHuman player) {
        }

        protected void a(@Nullable EntityHuman player, @Nullable IInventory container) {
        }

        public void e(int i) {
        }

        public void h(int i) {
        }

        private void updateSlot(int slotIndex, @NotNull IInventory container) {
            Slot slot = (Slot)this.k.get(slotIndex);
            Slot newSlot = new Slot(container, slot.a, slot.e, slot.f);
            newSlot.d = slot.d;
            this.k.set(slotIndex, (Object)newSlot);
        }
    }

    private static abstract class InventoryViewProvider
    extends InventoryMerchant
    implements ITileInventory {
        public InventoryViewProvider(@NotNull IMerchant merchant) {
            super(merchant);
        }
    }
}

