/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.player;

import java.util.UUID;
import net.mathias2246.buildmc.api.event.player.PlayerHeadDropEvent;
import net.mathias2246.buildmc.api.item.ItemMetaModifier;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

public record PlayerHeadDropDeathListener(@Nullable ItemMetaModifier modifier) implements Listener
{
    @EventHandler(priority=EventPriority.LOWEST)
    private void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Entity killer = event.getDamageSource().getCausingEntity();
        if (killer == null) {
            return;
        }
        if (!(killer instanceof Player)) {
            return;
        }
        Player killerPlayer = (Player)killer;
        if (event.getKeepInventory()) {
            return;
        }
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = playerHead.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return;
        }
        SkullMeta meta = (SkullMeta)itemMeta;
        if (this.modifier != null) {
            this.modifier.modifyMeta((ItemMeta)meta, player, event);
        }
        meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()));
        playerHead.setItemMeta((ItemMeta)meta);
        PlayerHeadDropEvent headDropEvent = new PlayerHeadDropEvent(player, killerPlayer, playerHead, event);
        Bukkit.getPluginManager().callEvent((Event)headDropEvent);
        if (headDropEvent.isCancelled()) {
            return;
        }
        ItemStack newPlayerHead = headDropEvent.getPlayerHead();
        event.getDrops().add(newPlayerHead);
    }
}

