/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.player;

import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.event.player.PlayerSpawnTeleportPreConditionEvent;
import net.mathias2246.buildmc.commandAPI.CommandAPICommand;
import net.mathias2246.buildmc.commandAPI.executors.ExecutorType;
import net.mathias2246.buildmc.commands.CommandUtil;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.player.TeleportTimer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerSpawnTeleportCommand
implements CustomCommand {
    @Override
    public CommandAPICommand getCommand() {
        CommandAPICommand cmd = new CommandAPICommand("spawn");
        cmd.withRequirement(command -> command.hasPermission("buildmc.allow-spawn-teleport"));
        cmd.executes(command -> {
            Player player = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (player == null) {
                return 0;
            }
            PlayerSpawnTeleportPreConditionEvent e = new PlayerSpawnTeleportPreConditionEvent(player, player.getWorld().getSpawnLocation());
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.spawn-teleport.not-working"));
                return 0;
            }
            TeleportTimer timer = new TeleportTimer(player, e.getTo());
            timer.start(0);
            return 1;
        }, new ExecutorType[0]);
        return cmd;
    }
}

