/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.player;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.util.Message;
import net.mathias2246.buildmc.util.PlayerTimer;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class TeleportTimer
extends PlayerTimer {
    static final Sound notification = Sound.sound(Key.key(CoreMain.plugin.getConfig().getString("sounds.notification", "minecraft:entity.item.pickup")), Sound.Source.MASTER, 1.0f, 1.0f);
    static final Sound mistake = Sound.sound(Key.key(CoreMain.plugin.getConfig().getString("sounds.mistake", "minecraft:block.note_block.snare")), Sound.Source.MASTER, 1.0f, 1.0f);
    static final Sound success = Sound.sound(Key.key(CoreMain.plugin.getConfig().getString("sounds.success", "minecraft:block.note_block.bell")), Sound.Source.MASTER, 1.0f, 1.0f);
    public static final int seconds = CoreMain.plugin.getConfig().getInt("spawn-teleport.wait-for");
    private Vector previousPosition;
    @NotNull
    private final Location to;

    public TeleportTimer(@NotNull Player player, @NotNull Location to) {
        super(CoreMain.plugin, player, seconds, 20);
        this.to = to;
    }

    @Override
    public void onExit() {
        CoreMain.mainClass.sendMessage((CommandSender)this.player, Component.translatable("messages.teleport.successful"));
        this.player.teleport(this.to);
        CoreMain.soundManager.playSound(this.player, success);
    }

    @Override
    protected void init() {
        this.previousPosition = this.player.getLocation().toVector();
    }

    @Override
    protected boolean shouldCancel() {
        return !this.player.isOnline() || !this.player.getLocation().toVector().equals((Object)this.previousPosition);
    }

    @Override
    protected void onCancel() {
        CoreMain.mainClass.sendMessage((CommandSender)this.player, Component.translatable("messages.teleport.cancelled"));
        CoreMain.soundManager.playSound(this.player, mistake);
    }

    @Override
    protected void onStep() {
        TextReplacementConfig r = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%seconds%").replacement(String.valueOf(this.steps - this.currentStep)).build();
        CoreMain.mainClass.sendPlayerActionBar(this.player, Message.msg(this.player, "messages.teleport.counter").replaceText(r));
        CoreMain.soundManager.playSound(this.player, notification);
    }
}

