/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.util;

import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerTimer
extends BukkitRunnable {
    public int currentStep;
    public final int steps;
    public final int ticks;
    @NotNull
    public final Player player;
    @NotNull
    public final Plugin plugin;

    public PlayerTimer(@NotNull Plugin plugin, @NotNull Player player, int steps, int ticks) {
        this.steps = steps;
        this.player = player;
        this.ticks = ticks;
        this.plugin = plugin;
    }

    public void start(int tickDelay) {
        this.init();
        if (this.steps <= 0) {
            this.onExit();
        }
        this.runTaskTimer(this.plugin, tickDelay, this.ticks);
    }

    public abstract void onExit();

    protected abstract void init();

    protected abstract boolean shouldCancel();

    protected abstract void onCancel();

    protected abstract void onStep();

    public void run() {
        ++this.currentStep;
        if (this.shouldCancel()) {
            this.cancel();
            this.currentStep = 0;
            this.onCancel();
            return;
        }
        if (this.currentStep > this.steps) {
            this.onExit();
            this.cancel();
            this.currentStep = 0;
            return;
        }
        this.onStep();
    }
}

