/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mathias2246.buildmc.util.DeferredRegistry;
import org.bukkit.Keyed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistriesHolder {
    private final Map<String, DeferredRegistry<? extends Keyed>> registries = new HashMap<String, DeferredRegistry<? extends Keyed>>();

    private RegistriesHolder() {
    }

    @Nullable
    public DeferredRegistry<?> get(@NotNull String key) {
        return this.registries.get(key);
    }

    @Nullable
    public <T extends Keyed> DeferredRegistry<T> getAsType(@NotNull String key) {
        try {
            return this.registries.get(key);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public <T extends Keyed> DeferredRegistry<T> addRegistry(@NotNull String key, @NotNull DeferredRegistry<T> registry) {
        if (this.registries.containsKey(key)) {
            return registry;
        }
        this.registries.put(key, registry);
        return registry;
    }

    public <T extends Keyed> Optional<DeferredRegistry<T>> getOptional(@Nullable String key) {
        DeferredRegistry<? extends Keyed> r;
        if (key == null) {
            return Optional.empty();
        }
        try {
            r = this.registries.get(key);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.ofNullable(r);
    }

    public static class Builder {
        private final RegistriesHolder holder = new RegistriesHolder();

        public Builder addRegistry(@NotNull String key, @NotNull DeferredRegistry<? extends Keyed> registry) {
            if (this.holder.registries.containsKey(key)) {
                return this;
            }
            this.holder.registries.put(key, registry);
            return this;
        }

        public RegistriesHolder build() {
            return this.holder;
        }
    }
}

