/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_16_2_3;

import com.github.stefvanschie.inventoryframework.abstraction.EnchantingTableInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_16_2_3.util.TextHolderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.Container;
import net.minecraft.server.v1_16_R2.ContainerAccess;
import net.minecraft.server.v1_16_R2.ContainerEnchantTable;
import net.minecraft.server.v1_16_R2.ContainerUtil;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.IInventory;
import net.minecraft.server.v1_16_R2.ItemStack;
import net.minecraft.server.v1_16_R2.NonNullList;
import net.minecraft.server.v1_16_R2.PlayerInventory;
import net.minecraft.server.v1_16_R2.Slot;
import net.minecraft.server.v1_16_R2.TileEntityContainer;
import net.minecraft.server.v1_16_R2.TileEntityTypes;
import net.minecraft.server.v1_16_R2.World;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantingTableInventoryImpl
extends EnchantingTableInventory {
    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory(final @NotNull TextHolder title) {
        InventoryViewProvider container = new InventoryViewProvider(){

            @NotNull
            @Contract(pure=true)
            public Container createContainer(int containerId, @NotNull PlayerInventory inventory) {
                return new ContainerEnchantingTableImpl(containerId, inventory.player, (IInventory)this);
            }

            @NotNull
            @Contract(pure=true)
            public IChatBaseComponent getContainerName() {
                return TextHolderUtil.toComponent(title);
            }
        };
        return new CraftInventoryEnchanting((IInventory)container, (IInventory)container){
            final /* synthetic */ IInventory val$container;
            {
                this.val$container = iInventory;
                super(inventory);
            }

            @NotNull
            @Contract(pure=true)
            public InventoryType getType() {
                return InventoryType.ENCHANTING;
            }

            public IInventory getInventory() {
                return this.val$container;
            }
        };
    }

    private static class ContainerEnchantingTableImpl
    extends ContainerEnchantTable {
        @NotNull
        private final HumanEntity humanEntity;
        @NotNull
        private final IInventory inputSlots;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerEnchantingTableImpl(int containerId, @NotNull EntityHuman player, @NotNull IInventory inputSlots) {
            super(containerId, player.inventory, ContainerAccess.at((World)player.getWorld(), (BlockPosition)BlockPosition.ZERO));
            this.humanEntity = player.getBukkitEntity();
            this.inputSlots = inputSlots;
            this.checkReachable = false;
            this.updateSlot(0, inputSlots);
            this.updateSlot(1, inputSlots);
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity != null) {
                return this.bukkitEntity;
            }
            CraftInventoryEnchanting inventory = new CraftInventoryEnchanting(this.inputSlots);
            this.bukkitEntity = new CraftInventoryView(this.humanEntity, (Inventory)inventory, (Container)this);
            return this.bukkitEntity;
        }

        public void a(@Nullable IInventory container) {
        }

        public void b(@Nullable EntityHuman player) {
        }

        protected void a(@Nullable EntityHuman player, @Nullable World world, @Nullable IInventory container) {
        }

        private void updateSlot(int slotIndex, @NotNull IInventory container) {
            Slot slot = (Slot)this.slots.get(slotIndex);
            Slot newSlot = new Slot(container, slot.index, slot.e, slot.f);
            newSlot.rawSlotIndex = slot.rawSlotIndex;
            this.slots.set(slotIndex, newSlot);
        }
    }

    private static abstract class InventoryViewProvider
    extends TileEntityContainer {
        private final NonNullList<ItemStack> items = NonNullList.a((int)2, (Object)ItemStack.b);
        private final List<HumanEntity> transaction = new ArrayList<HumanEntity>();
        private int maxStack = 64;

        protected InventoryViewProvider() {
            super(TileEntityTypes.ENCHANTING_TABLE);
        }

        public void clear() {
            this.items.clear();
            this.update();
        }

        public int getSize() {
            return 2;
        }

        public boolean isEmpty() {
            for (ItemStack itemStack : this.items) {
                if (itemStack.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int index) {
            return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.b;
        }

        public ItemStack splitStack(int firstIndex, int secondIndex) {
            ItemStack itemstack = ContainerUtil.a(this.items, (int)firstIndex, (int)secondIndex);
            if (!itemstack.isEmpty()) {
                this.update();
            }
            return itemstack;
        }

        public ItemStack splitWithoutUpdate(int index) {
            ItemStack itemStack = (ItemStack)this.items.get(index);
            if (itemStack.isEmpty()) {
                return ItemStack.b;
            }
            this.items.set(index, (Object)ItemStack.b);
            return itemStack;
        }

        public void setItem(int index, ItemStack itemStack) {
            this.items.set(index, (Object)itemStack);
            if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
                itemStack.setCount(this.getMaxStackSize());
            }
            this.update();
        }

        public int getMaxStackSize() {
            return this.maxStack;
        }

        public boolean a(EntityHuman entityHuman) {
            return true;
        }

        public List<ItemStack> getContents() {
            return this.items;
        }

        public void onOpen(CraftHumanEntity craftHumanEntity) {
            this.transaction.add((HumanEntity)craftHumanEntity);
        }

        public void onClose(CraftHumanEntity craftHumanEntity) {
            this.transaction.remove(craftHumanEntity);
        }

        public List<HumanEntity> getViewers() {
            return this.transaction;
        }

        public void setMaxStackSize(int maxStack) {
            this.maxStack = maxStack;
        }
    }
}

