/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.protections.misc;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.item.ItemUtil;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.type.util.Gui;
import net.mathias2246.buildmc.ui.UIUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrostWalker
extends Protection {
    public FrostWalker(@Nullable ConfigurationSection section) {
        super(Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:frost_walker")), section != null ? section.getBoolean("default", true) : true, section != null && section.getBoolean("is-hidden", false));
    }

    @Override
    @NotNull
    public GuiItem getDisplay(@NotNull Player uiHolder, @NotNull Gui gui) {
        String t = this.getTranslationBaseKey();
        ItemStack displayBase = new ItemStack(Material.ICE);
        ItemUtil.editMeta(displayBase, meta -> {
            meta.setItemName(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".name")));
            meta.setLore(List.of(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".lore")).split("\n")));
        });
        return new GuiItem(displayBase, UIUtil.noInteract);
    }

    @Override
    public String getTranslationBaseKey() {
        return "claims.flags.frost-walker";
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFrostWalkerUse(EntityBlockFormEvent event) {
        if (!event.getNewState().getType().equals((Object)Material.FROSTED_ICE)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack boots = player.getInventory().getBoots();
        if (boots == null || !boots.containsEnchantment(Enchantment.FROST_WALKER)) {
            return;
        }
        if (!ClaimManager.isPlayerAllowed(player, this.getKey(), event.getBlock().getLocation())) {
            event.setCancelled(true);
            CoreMain.mainClass.sendPlayerActionBar(player, Component.translatable("messages.claims.not-accessible.frostwalker"));
        }
    }
}

