/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.protections.misc;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.item.ItemUtil;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.type.util.Gui;
import net.mathias2246.buildmc.ui.UIUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionSplash
extends Protection {
    public PotionSplash(@Nullable ConfigurationSection section) {
        super(Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:splash_potion")), section != null ? section.getBoolean("default", true) : true, section != null && section.getBoolean("is-hidden", false));
    }

    @Override
    public String getTranslationBaseKey() {
        return "claims.flags.splash-potions";
    }

    @Override
    @NotNull
    public GuiItem getDisplay(@NotNull Player uiHolder, @NotNull Gui gui) {
        String t = this.getTranslationBaseKey();
        ItemStack displayBase = new ItemStack(Material.SPLASH_POTION);
        ItemMeta itemMeta = displayBase.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)itemMeta;
            potion.setBasePotionType(null);
            displayBase.setItemMeta((ItemMeta)potion);
        }
        ItemUtil.editMeta(displayBase, meta -> {
            meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".name")));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setLore(List.of(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".lore")).split("\n")));
        });
        return new GuiItem(displayBase, UIUtil.noInteract);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPotionSplash(PotionSplashEvent event) {
        Player player;
        ThrownPotion thrownPotion = event.getPotion();
        ProjectileSource projectileSource = thrownPotion.getShooter();
        if (projectileSource instanceof Player && !ClaimManager.isPlayerAllowed(player = (Player)projectileSource, this.getKey(), thrownPotion.getLocation())) {
            CoreMain.mainClass.sendPlayerActionBar(player, Component.translatable("messages.claims.not-accessible.potion-splash"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        Player player;
        ThrownPotion thrownPotion = event.getEntity();
        ProjectileSource projectileSource = thrownPotion.getShooter();
        if (projectileSource instanceof Player && !ClaimManager.isPlayerAllowed(player = (Player)projectileSource, this.getKey(), thrownPotion.getLocation())) {
            CoreMain.mainClass.sendPlayerActionBar(player, Component.translatable("messages.claims.not-accessible.potion-splash"));
            event.setCancelled(true);
        }
    }
}

