/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.tool;

import com.destroystokyo.paper.ParticleBuilder;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.util.LocationUtil;
import net.mathias2246.buildmc.util.ParticleSpawner;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.jetbrains.annotations.NotNull;

public class ClaimToolParticles
extends ParticleSpawner {
    public final boolean isRemoveSelection;
    private ParticleBuilder chunkPlane;
    private ParticleBuilder corner1;
    private ParticleBuilder corner2;
    private ParticleBuilder corner3;
    private ParticleBuilder corner4;

    public ClaimToolParticles(int repeatTimes, int delay, @NotNull Player source, boolean isRemoveSelection) {
        super(repeatTimes, delay, source);
        this.isRemoveSelection = isRemoveSelection;
        Location l = LocationUtil.tryDeserialize(((MetadataValue)source.getMetadata("buildmc:claim_tool_first_selection").getFirst()).asString());
        if (l == null) {
            return;
        }
        Chunk c = l.getChunk();
        l.setX((double)((c.getX() << 4) + 8));
        l.setZ((double)((c.getZ() << 4) + 8));
        l.setY(l.getY() + 1.5);
        this.chunkPlane = isRemoveSelection ? new ParticleBuilder(Particle.DUST).color(210, 10, 10).count(100).receivers(new Player[]{source}).location(l).offset(2.6, 0.0, 2.6) : new ParticleBuilder(Particle.DUST).color(10, 230, 10).count(100).receivers(new Player[]{source}).location(l).offset(2.6, 0.0, 2.6);
        ParticleBuilder cornerBase = new ParticleBuilder(Particle.DUST).color(10, 10, 230).count(30).receivers(new Player[]{source}).offset(0.0, 1.5, 0.0);
        Location l1 = new Location(source.getWorld(), (double)(source.getChunk().getX() << 4) + 0.5, l.getY(), (double)(source.getChunk().getZ() << 4) + 0.5);
        this.corner1 = cornerBase.clone().location(l1);
        Location l2 = new Location(source.getWorld(), (double)(source.getChunk().getX() << 4) + 15.5, l.getY(), (double)(source.getChunk().getZ() << 4) + 0.0);
        this.corner2 = cornerBase.clone().location(l2);
        Location l3 = new Location(source.getWorld(), (double)(source.getChunk().getX() << 4) + 0.0, l.getY(), (double)(source.getChunk().getZ() << 4) + 15.5);
        this.corner3 = cornerBase.clone().location(l3);
        Location l4 = new Location(source.getWorld(), (double)(source.getChunk().getX() << 4) + 15.5, l.getY(), (double)(source.getChunk().getZ() << 4) + 15.5);
        this.corner4 = cornerBase.clone().location(l4);
    }

    @Override
    public void buildParticleSpawner() {
    }

    @Override
    protected boolean shouldStop() {
        return !this.source.hasMetadata("claim_selection_particles");
    }

    @Override
    protected void display() {
        this.chunkPlane.spawn();
        this.corner1.spawn();
        this.corner2.spawn();
        this.corner3.spawn();
        this.corner4.spawn();
    }

    @Override
    protected void onStop() {
        this.source.removeMetadata("claim_selection_particles", Main.plugin);
    }

    public static class Builder
    implements ParticleSpawner.Builder<ClaimToolParticles> {
        @Override
        public ClaimToolParticles build(@NotNull Player player) {
            return new ClaimToolParticles(24, 5, player, false);
        }
    }
}

