/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.tools;

import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.item.abstractTypes.AbstractSelectionTool;
import net.mathias2246.buildmc.util.Message;
import net.mathias2246.buildmc.util.ParticleSpawner;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ClaimSelectionTool
extends AbstractSelectionTool {
    @NotNull
    public final Sound successSound = Sound.sound(Key.key(CoreMain.plugin.getConfig().getString("sounds.success", "minecraft:block.note_block.bell")), Sound.Source.MASTER, 1.0f, 1.0f);
    @NotNull
    public final Sound mistakeSound = Sound.sound(Key.key(CoreMain.plugin.getConfig().getString("sounds.mistake", "minecraft:block.note_block.snare")), Sound.Source.MASTER, 1.0f, 1.0f);
    @NotNull
    public final ParticleSpawner.Builder<?> particles;
    private final int maxSelectionSize;

    @ApiStatus.Internal
    public ClaimSelectionTool(@NotNull Plugin plugin, @NotNull NamespacedKey key, @NotNull ParticleSpawner.Builder<?> particles) {
        super(plugin, key);
        this.particles = particles;
        this.maxSelectionSize = plugin.getConfig().getInt("claims.tool.limit-selection", 8);
    }

    @Override
    public boolean canUse(@NotNull ItemStack item, @NotNull PlayerInteractEvent event) {
        return !event.getPlayer().hasCooldown(item);
    }

    @Override
    @NotNull
    protected ItemStack buildDefaultItemStack() {
        ItemStack claimToolItemstack = ItemStack.deserialize((Map)Objects.requireNonNull(this.getPlugin().getConfig().getConfigurationSection("claims.tool.tool-item")).getValues(false));
        ItemMeta m = claimToolItemstack.getItemMeta();
        if (m != null) {
            m.setItemName("Select Claim Corners");
            m.setTool(null);
            m.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE});
            m.setUnbreakable(true);
            m.setRarity(ItemRarity.UNCOMMON);
            m.setEnchantmentGlintOverride(Boolean.valueOf(true));
            m.setEnchantable(null);
            claimToolItemstack.setItemMeta(m);
        }
        return claimToolItemstack;
    }

    @Override
    public boolean allowFirstSelection(@NotNull ItemStack item, @NotNull Location at, @NotNull PlayerInteractEvent event) {
        return true;
    }

    public boolean isSelectionToLarge(@NotNull Location from, @NotNull Location to, @NotNull Player player) {
        if (this.maxSelectionSize < 0) {
            return false;
        }
        int fx = from.getChunk().getX();
        int fz = from.getChunk().getZ();
        int tx = to.getChunk().getX();
        int tz = to.getChunk().getZ();
        int startX = Math.min(fx, tx);
        int startZ = Math.min(fz, tz);
        int endX = Math.max(fx, tx);
        int endZ = Math.max(fz, tz);
        return endX - startX > this.maxSelectionSize || endZ - startZ > this.maxSelectionSize;
    }

    @Override
    public boolean allowSecondSelection(@NotNull ItemStack item, @NotNull Location at, @NotNull PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = player.getLocation().getChunk();
        Location first = this.getFirstSelection(player);
        if (player.hasCooldown(item)) {
            CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.tool.tool-cooldown"));
            CoreMain.soundManager.playSound(player, this.mistakeSound);
            return false;
        }
        if (first == null) {
            CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.tool.no-first-selection"));
            CoreMain.soundManager.playSound(player, this.mistakeSound);
            return false;
        }
        if (this.isSelectionToLarge(first, at, player)) {
            Component msg = Message.msg(player, "messages.claims.tool.selection-too-large");
            msg = msg.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%selection_limit%").replacement(Integer.toString(this.maxSelectionSize)).build());
            CoreMain.mainClass.sendMessage((CommandSender)player, msg);
            CoreMain.soundManager.playSound(player, this.mistakeSound);
            return false;
        }
        return true;
    }

    @Override
    public void onSuccessfulFirstSelection(@NotNull ItemStack item, @NotNull Location at, @NotNull PlayerInteractEvent event) {
        Player player = event.getPlayer();
        CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.tool.set-pos1"));
        CoreMain.soundManager.playSound(player, this.successSound);
        player.setCooldown(item, 60);
        if (!player.hasMetadata("claim_selection_particles")) {
            player.setMetadata("claim_selection_particles", (MetadataValue)new FixedMetadataValue(this.getPlugin(), null));
            Object p = this.particles.build(player);
            p.runTaskTimer(this.getPlugin(), 0L, (long)((ParticleSpawner)((Object)p)).delay);
        }
    }

    @Override
    public void onSuccessfulSecondSelection(@NotNull ItemStack item, @NotNull Location at, @NotNull PlayerInteractEvent event) {
        Player player = event.getPlayer();
        player.setCooldown(item, 60);
        CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.tool.set-pos2"));
        CoreMain.soundManager.playSound(player, this.successSound);
        if (player.hasMetadata(this.firstSelectionKey) && player.hasMetadata(this.secondSelectionKey)) {
            CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.tool.both-positions-set"));
        }
    }
}

