/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.endEvent.EndEventCommand;
import net.mathias2246.buildmc.spawnElytra.ElytraZoneCommand;
import org.bukkit.command.CommandSender;

public class BuildMcCommand
implements CustomCommand {
    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        LiteralArgumentBuilder cmd = Commands.literal((String)"buildmc");
        cmd.executes(executionInfo -> {
            ((CommandSourceStack)executionInfo.getSource()).getSender().sendMessage("/buildmc <args>");
            return 1;
        });
        LiteralArgumentBuilder debugSub = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").requires(c -> c.getSender().hasPermission("buildmc.admin"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("/buildmc debug <args>");
            return 1;
        });
        LiteralArgumentBuilder miniMsgSub = (LiteralArgumentBuilder)Commands.literal((String)"minimessage").then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            Object component;
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            String input = StringArgumentType.getString((CommandContext)ctx, (String)"message");
            MiniMessage mm = MiniMessage.miniMessage();
            try {
                component = mm.deserialize(input);
            }
            catch (Exception e) {
                sender.sendMessage((Component)Component.text("\u274c Failed to parse MiniMessage: " + e.getMessage(), (TextColor)NamedTextColor.RED));
                return 0;
            }
            sender.sendMessage((Component)Component.text("Rendered Component:"));
            sender.sendMessage(component);
            String json = (String)GsonComponentSerializer.gson().serialize(component);
            StyleSetter jsonCopy = ((TextComponent)Component.text("\ud83d\udccb Click to copy JSON", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.copyToClipboard(json))).hoverEvent((HoverEventSource)Component.text("Copy this component's JSON to your clipboard"));
            sender.sendMessage((Component)jsonCopy);
            return 1;
        }));
        debugSub.then((ArgumentBuilder)miniMsgSub);
        cmd.then((ArgumentBuilder)debugSub);
        LiteralArgumentBuilder statusSub = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"status").requires(c -> c.getSender().hasPermission("buildmc.admin"))).then(Commands.literal((String)"reload").executes(c -> {
            Main.statusConfig.reload();
            return 1;
        }));
        cmd.then((ArgumentBuilder)statusSub);
        LiteralArgumentBuilder<CommandSourceStack> endSub = new EndEventCommand().getCommandBuilder();
        cmd.then(endSub);
        LiteralArgumentBuilder<CommandSourceStack> elytraSub = new ElytraZoneCommand().getSubCommand();
        cmd.then(elytraSub);
        return cmd.build();
    }
}

