/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.database;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.database.DatabaseTable;
import net.mathias2246.buildmc.util.LocationUtil;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimTable
implements DatabaseTable {
    private final Cache<@NotNull Long, @NotNull Claim> claimCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(10L, TimeUnit.MINUTES).build();

    @Override
    public void createTable(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.execute("    CREATE TABLE IF NOT EXISTS claims (\n        id IDENTITY PRIMARY KEY,\n        type VARCHAR(16) NOT NULL,\n        owner_id VARCHAR(64) NOT NULL,\n        world_id UUID NOT NULL,\n        chunk_x1 INT NOT NULL,\n        chunk_z1 INT NOT NULL,\n        chunk_x2 INT NOT NULL,\n        chunk_z2 INT NOT NULL,\n        name VARCHAR(100)\n    );\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS claim_whitelisted_players (\n        claim_id BIGINT NOT NULL,\n        player_uuid UUID NOT NULL,\n        PRIMARY KEY (claim_id, player_uuid),\n        FOREIGN KEY (claim_id) REFERENCES claims(id) ON DELETE CASCADE\n    );\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS claim_protection_flags (\n        claim_id BIGINT NOT NULL,\n        flag VARCHAR(64) NOT NULL,\n        PRIMARY KEY (claim_id, flag),\n        FOREIGN KEY (claim_id) REFERENCES claims(id) ON DELETE CASCADE\n    );\n");
            stmt.execute("     CREATE INDEX IF NOT EXISTS idx_claims_owner_id \n     ON claims(owner_id);\n ");
            stmt.execute("     CREATE INDEX IF NOT EXISTS idx_claims_world_id \n     ON claims(world_id);\n ");
            stmt.execute("     CREATE INDEX IF NOT EXISTS idx_claims_chunks \n     ON claims(world_id, chunk_x1, chunk_z1, chunk_x2, chunk_z2);\n ");
            stmt.execute("     CREATE INDEX IF NOT EXISTS idx_whitelisted_claim_id \n     ON claim_whitelisted_players(claim_id);\n ");
            stmt.execute("     CREATE INDEX IF NOT EXISTS idx_whitelisted_player_uuid \n     ON claim_whitelisted_players(player_uuid);\n ");
            stmt.execute("     CREATE INDEX IF NOT EXISTS idx_flags_claim_id \n     ON claim_protection_flags(claim_id);\n ");
        }
    }

    public long insertClaim(Connection conn, Claim claim) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("    INSERT INTO claims (type, owner_id, world_id, chunk_x1, chunk_z1, chunk_x2, chunk_z2, name)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?)\n", 1);){
            ps.setString(1, claim.getType().name());
            ps.setString(2, claim.getOwnerId());
            ps.setObject(3, claim.getWorldId());
            ps.setInt(4, claim.getChunkX1());
            ps.setInt(5, claim.getChunkZ1());
            ps.setInt(6, claim.getChunkX2());
            ps.setInt(7, claim.getChunkZ2());
            ps.setString(8, claim.getName());
            ps.executeUpdate();
            try (ResultSet rs = ps.getGeneratedKeys();){
                if (rs.next()) {
                    long id = rs.getLong(1);
                    try (PreparedStatement whitelistPS = conn.prepareStatement("    INSERT INTO claim_whitelisted_players (claim_id, player_uuid)\n    VALUES (?, ?)\n");){
                        for (UUID uuid : claim.getWhitelistedPlayers()) {
                            whitelistPS.setLong(1, id);
                            whitelistPS.setObject(2, uuid);
                            whitelistPS.addBatch();
                        }
                        whitelistPS.executeBatch();
                    }
                    try (PreparedStatement flagPS = conn.prepareStatement("    INSERT INTO claim_protection_flags (claim_id, flag)\n    VALUES (?, ?)\n");){
                        for (String flag : claim.getProtections()) {
                            flagPS.setLong(1, id);
                            flagPS.setString(2, flag);
                            flagPS.addBatch();
                        }
                        flagPS.executeBatch();
                    }
                    this.claimCache.put(id, claim);
                    this.updateRemainingClaims(claim);
                    long l = id;
                    return l;
                }
                throw new SQLException("Inserting claim failed, no ID obtained.");
            }
        }
    }

    private void updateRemainingClaims(Claim claim) {
        int width = Math.abs(claim.getChunkX2() - claim.getChunkX1()) + 1;
        int height = Math.abs(claim.getChunkZ2() - claim.getChunkZ1()) + 1;
        int claimedArea = width * height;
        String ownerId = claim.getOwnerId();
        if (ownerId == null || ownerId.isEmpty()) {
            CoreMain.plugin.getLogger().warning("Claim inserted without ownerId. Skipping remaining claims update.");
            return;
        }
        switch (claim.getType()) {
            case TEAM: {
                int maxChunks = CoreMain.plugin.getConfig().getInt("claims.team-max-chunk-claim-amount", 0);
                ClaimManager.teamRemainingClaims.compute(ownerId, (team, remaining) -> {
                    if (remaining == null) {
                        remaining = maxChunks;
                    }
                    int newValue = remaining - claimedArea;
                    return Math.max(newValue, 0);
                });
                break;
            }
            case PLAYER: {
                int maxChunks = CoreMain.plugin.getConfig().getInt("claims.player-max-chunk-claim-amount", 0);
                ClaimManager.playerRemainingClaims.compute(ownerId, (player, remaining) -> {
                    if (remaining == null) {
                        remaining = maxChunks;
                    }
                    int newValue = remaining - claimedArea;
                    return Math.max(newValue, 0);
                });
            }
        }
    }

    public void deleteClaimById(Connection conn, long claimId) throws SQLException {
        Claim claim = this.getClaimById(conn, claimId);
        if (claim == null) {
            CoreMain.plugin.getLogger().warning("Attempted to delete claim ID " + claimId + " but it was not found.");
            return;
        }
        try (PreparedStatement ps = conn.prepareStatement("    DELETE FROM claims WHERE id = ?\n");){
            ps.setLong(1, claimId);
            ps.executeUpdate();
        }
        this.claimCache.invalidate(claimId);
        switch (claim.getType()) {
            case PLAYER: {
                UUID uuid = UUID.fromString(claim.getOwnerId());
                List<Long> claims = ClaimManager.playerOwner.get(uuid);
                if (claims == null) break;
                claims.remove(claimId);
                if (!claims.isEmpty()) break;
                ClaimManager.playerOwner.remove(uuid);
                break;
            }
            case TEAM: {
                List<Long> claims = ClaimManager.teamOwner.get(claim.getOwnerId());
                if (claims == null) break;
                claims.remove(claimId);
                if (!claims.isEmpty()) break;
                ClaimManager.teamOwner.remove(claim.getOwnerId());
                break;
            }
            case SERVER: {
                ClaimManager.serverClaims.remove(claimId);
                break;
            }
            case PLACEHOLDER: {
                ClaimManager.placeholderClaims.remove(claimId);
            }
        }
        this.restoreRemainingClaims(claim);
    }

    private void restoreRemainingClaims(Claim claim) {
        int width = Math.abs(claim.getChunkX2() - claim.getChunkX1()) + 1;
        int height = Math.abs(claim.getChunkZ2() - claim.getChunkZ1()) + 1;
        int claimedArea = width * height;
        String ownerId = claim.getOwnerId();
        if (ownerId == null || ownerId.isEmpty()) {
            CoreMain.plugin.getLogger().warning("Claim deletion without ownerId. Skipping remaining claims restore.");
            return;
        }
        switch (claim.getType()) {
            case TEAM: {
                int maxChunks = CoreMain.plugin.getConfig().getInt("claims.team-max-chunk-claim-amount", 0);
                ClaimManager.teamRemainingClaims.compute(ownerId, (team, remaining) -> {
                    if (remaining == null) {
                        remaining = maxChunks;
                    }
                    int newValue = remaining + claimedArea;
                    return Math.min(newValue, maxChunks);
                });
                break;
            }
            case PLAYER: {
                int maxChunks = CoreMain.plugin.getConfig().getInt("claims.player-max-chunk-claim-amount", 0);
                ClaimManager.playerRemainingClaims.compute(ownerId, (player, remaining) -> {
                    if (remaining == null) {
                        remaining = maxChunks;
                    }
                    int newValue = remaining + claimedArea;
                    return Math.min(newValue, maxChunks);
                });
            }
        }
    }

    public Claim getClaimById(Connection conn, long id) throws SQLException {
        Claim cached = this.claimCache.getIfPresent(id);
        if (cached != null) {
            return cached;
        }
        try (PreparedStatement ps = conn.prepareStatement("    SELECT * FROM claims WHERE id = ?\n");){
            Claim claim;
            block17: {
                ResultSet rs;
                block15: {
                    Claim claim2;
                    block16: {
                        ps.setLong(1, id);
                        rs = ps.executeQuery();
                        try {
                            if (!rs.next()) break block15;
                            ArrayList<UUID> whitelistedPlayers = new ArrayList<UUID>();
                            ArrayList<String> protections = new ArrayList<String>();
                            this.loadClaimRelations(conn, id, whitelistedPlayers, protections);
                            Claim claim3 = new Claim(id, ClaimType.valueOf(rs.getString("type")), rs.getString("owner_id"), (UUID)rs.getObject("world_id"), rs.getInt("chunk_x1"), rs.getInt("chunk_z1"), rs.getInt("chunk_x2"), rs.getInt("chunk_z2"), rs.getString("name"), whitelistedPlayers, protections);
                            this.claimCache.put(id, claim3);
                            claim2 = claim3;
                            if (rs == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return claim2;
                }
                claim = null;
                if (rs == null) break block17;
                rs.close();
            }
            return claim;
        }
    }

    private void loadClaimRelations(Connection conn, long claimId, Collection<UUID> whitelistedPlayers, Collection<String> protections) throws SQLException {
        ResultSet rs;
        try (PreparedStatement ps = conn.prepareStatement("    SELECT player_uuid FROM claim_whitelisted_players WHERE claim_id = ?\n");){
            ps.setLong(1, claimId);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    whitelistedPlayers.add((UUID)rs.getObject("player_uuid"));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        ps = conn.prepareStatement("    SELECT flag FROM claim_protection_flags WHERE claim_id = ?\n");
        try {
            ps.setLong(1, claimId);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    protections.add(rs.getString("flag"));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public List<Claim> getAllClaims(Connection conn) throws SQLException {
        ArrayList<Claim> allClaims = new ArrayList<Claim>();
        try (PreparedStatement ps = conn.prepareStatement("    SELECT id, type, owner_id, world_id, chunk_x1, chunk_z1, chunk_x2, chunk_z2, name\n    FROM claims\n");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long id = rs.getLong("id");
                Claim cached = this.claimCache.getIfPresent(id);
                if (cached != null) {
                    allClaims.add(cached);
                    continue;
                }
                ArrayList<UUID> whitelistedPlayers = new ArrayList<UUID>();
                ArrayList<String> protections = new ArrayList<String>();
                this.loadClaimRelations(conn, id, whitelistedPlayers, protections);
                Claim claim = new Claim(id, ClaimType.valueOf(rs.getString("type")), rs.getString("owner_id"), (UUID)rs.getObject("world_id"), rs.getInt("chunk_x1"), rs.getInt("chunk_z1"), rs.getInt("chunk_x2"), rs.getInt("chunk_z2"), rs.getString("name"), whitelistedPlayers, protections);
                this.claimCache.put(id, claim);
                allClaims.add(claim);
            }
        }
        return allClaims;
    }

    public void invalidateClaim(long id) {
        this.claimCache.invalidate(id);
    }

    public void updateCache(long id, Claim updatedClaim) {
        this.claimCache.put(id, updatedClaim);
    }

    public boolean doesClaimExistInArea(Connection conn, UUID worldId, int chunkX1, int chunkZ1, int chunkX2, int chunkZ2) throws SQLException {
        int minX = Math.min(chunkX1, chunkX2);
        int maxX = Math.max(chunkX1, chunkX2);
        int minZ = Math.min(chunkZ1, chunkZ2);
        int maxZ = Math.max(chunkZ1, chunkZ2);
        try (PreparedStatement ps = conn.prepareStatement("    SELECT 1 FROM claims\n    WHERE world_id = ?\n      AND NOT (\n        chunk_x2 < ? OR\n        chunk_x1 > ? OR\n        chunk_z2 < ? OR\n        chunk_z1 > ?\n      )\n    LIMIT 1\n");){
            boolean bl;
            block12: {
                ps.setObject(1, worldId);
                ps.setInt(2, minX);
                ps.setInt(3, maxX);
                ps.setInt(4, minZ);
                ps.setInt(5, maxZ);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    public List<Claim> getOverlappingClaimsInArea(Connection conn, UUID worldId, int x1, int z1, int x2, int z2) throws SQLException {
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minZ = Math.min(z1, z2);
        int maxZ = Math.max(z1, z2);
        ArrayList<Claim> overlappingClaims = new ArrayList<Claim>();
        try (PreparedStatement ps = conn.prepareStatement("    SELECT id, type, owner_id, world_id, chunk_x1, chunk_z1, chunk_x2, chunk_z2, name\n    FROM claims\n    WHERE world_id = ?\n      AND NOT (\n        chunk_x2 < ? OR\n        chunk_x1 > ? OR\n        chunk_z2 < ? OR\n        chunk_z1 > ?\n      )\n");){
            ps.setObject(1, worldId);
            ps.setInt(2, minX);
            ps.setInt(3, maxX);
            ps.setInt(4, minZ);
            ps.setInt(5, maxZ);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long id = rs.getLong("id");
                    Claim cached = this.claimCache.getIfPresent(id);
                    if (cached != null) {
                        overlappingClaims.add(cached);
                        continue;
                    }
                    ArrayList<UUID> whitelistedPlayers = new ArrayList<UUID>();
                    ArrayList<String> protections = new ArrayList<String>();
                    this.loadClaimRelations(conn, id, whitelistedPlayers, protections);
                    Claim claim = new Claim(id, ClaimType.valueOf(rs.getString("type")), rs.getString("owner_id"), (UUID)rs.getObject("world_id"), rs.getInt("chunk_x1"), rs.getInt("chunk_z1"), rs.getInt("chunk_x2"), rs.getInt("chunk_z2"), rs.getString("name"), whitelistedPlayers, protections);
                    overlappingClaims.add(claim);
                    this.claimCache.put(id, claim);
                }
            }
        }
        return overlappingClaims;
    }

    public void addWhitelistedPlayer(Connection conn, long claimId, UUID playerUuid) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("    MERGE INTO claim_whitelisted_players (claim_id, player_uuid)\n    KEY (claim_id, player_uuid)\n    VALUES (?, ?)\n");){
            ps.setLong(1, claimId);
            ps.setObject(2, playerUuid);
            ps.executeUpdate();
        }
    }

    public void removeWhitelistedPlayer(Connection conn, long claimId, UUID playerUuid) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("    DELETE FROM claim_whitelisted_players\n    WHERE claim_id = ? AND player_uuid = ?\n");){
            ps.setLong(1, claimId);
            ps.setObject(2, playerUuid);
            ps.executeUpdate();
        }
    }

    public void addProtectionFlag(Connection conn, long claimId, @NotNull NamespacedKey protectionKey) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("    MERGE INTO claim_protection_flags (claim_id, flag)\n    KEY (claim_id, flag)\n    VALUES (?, ?)\n");){
            ps.setLong(1, claimId);
            ps.setString(2, protectionKey.toString());
            ps.executeUpdate();
        }
        Claim cached = this.claimCache.getIfPresent(claimId);
        if (cached != null) {
            cached.addProtection(protectionKey);
            this.claimCache.put(claimId, cached);
        }
    }

    public void removeProtectionFlag(Connection conn, long claimId, @NotNull NamespacedKey protectionKey) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("    DELETE FROM claim_protection_flags\n    WHERE claim_id = ? AND flag = ?\n");){
            ps.setLong(1, claimId);
            ps.setString(2, protectionKey.toString());
            ps.executeUpdate();
        }
        Claim cached = this.claimCache.getIfPresent(claimId);
        if (cached != null) {
            cached.removeProtection(protectionKey);
            this.claimCache.put(claimId, cached);
        }
    }

    public void loadClaimOwners(Connection conn) throws SQLException {
        HashMap<String, List<Long>> teamMap = new HashMap<String, List<Long>>();
        HashMap<UUID, List<Long>> playerMap = new HashMap<UUID, List<Long>>();
        ArrayList<Long> serverList = new ArrayList<Long>();
        ArrayList<Long> placeholderList = new ArrayList<Long>();
        try (PreparedStatement ps = conn.prepareStatement("    SELECT id, type, owner_id FROM claims\n");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long id = rs.getLong("id");
                ClaimType type = ClaimType.valueOf(rs.getString("type"));
                String ownerId = rs.getString("owner_id");
                switch (type) {
                    case TEAM: {
                        teamMap.computeIfAbsent(ownerId, k -> new ArrayList()).add(id);
                        break;
                    }
                    case PLAYER: {
                        UUID playerUuid = UUID.fromString(ownerId);
                        playerMap.computeIfAbsent(playerUuid, k -> new ArrayList()).add(id);
                        break;
                    }
                    case SERVER: {
                        serverList.add(id);
                        break;
                    }
                    case PLACEHOLDER: {
                        placeholderList.add(id);
                    }
                }
            }
        }
        ClaimManager.teamOwner = teamMap;
        ClaimManager.playerOwner = playerMap;
        ClaimManager.serverClaims = serverList;
        ClaimManager.placeholderClaims = placeholderList;
    }

    @Nullable
    public String getClaimNameById(Connection conn, long claimId) throws SQLException {
        Claim cached = this.claimCache.getIfPresent(claimId);
        if (cached != null) {
            return cached.getName();
        }
        try (PreparedStatement ps = conn.prepareStatement("    SELECT name FROM claims WHERE id = ?\n");){
            String string;
            block17: {
                ResultSet rs;
                block15: {
                    String string2;
                    block16: {
                        ps.setLong(1, claimId);
                        rs = ps.executeQuery();
                        try {
                            if (!rs.next()) break block15;
                            string2 = rs.getString("name");
                            if (rs == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = null;
                if (rs == null) break block17;
                rs.close();
            }
            return string;
        }
    }

    public boolean doesOwnerHaveClaimWithName(Connection conn, String ownerId, String claimName) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("    SELECT 1 FROM claims\n    WHERE owner_id = ? AND name = ?\n    LIMIT 1\n");){
            boolean bl;
            block12: {
                ps.setString(1, ownerId);
                ps.setString(2, claimName);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    public static void calculateRemainingClaims(Connection conn) throws SQLException {
        int maxChunks;
        ClaimManager.teamRemainingClaims = new HashMap<String, Integer>();
        ClaimManager.playerRemainingClaims = new HashMap<String, Integer>();
        for (String team : ClaimManager.teamOwner.keySet()) {
            maxChunks = CoreMain.plugin.getConfig().getInt("claims.team-max-chunk-claim-amount", 0);
            ClaimManager.teamRemainingClaims.put(team, maxChunks);
        }
        for (UUID player : ClaimManager.playerOwner.keySet()) {
            maxChunks = CoreMain.plugin.getConfig().getInt("claims.player-max-chunk-claim-amount", 0);
            ClaimManager.playerRemainingClaims.put(player.toString(), maxChunks);
        }
        String sql = "SELECT type, owner_id, chunk_x1, chunk_z1, chunk_x2, chunk_z2 FROM claims";
        try (PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                ClaimType type = ClaimType.valueOf(rs.getString("type"));
                String ownerId = rs.getString("owner_id");
                int x1 = rs.getInt("chunk_x1");
                int z1 = rs.getInt("chunk_z1");
                int x2 = rs.getInt("chunk_x2");
                int z2 = rs.getInt("chunk_z2");
                int chunkCount = LocationUtil.calculateChunkArea(x1, z1, x2, z2);
                switch (type) {
                    case TEAM: {
                        int maxChunks2 = CoreMain.plugin.getConfig().getInt("claims.team-max-chunk-claim-amount");
                        int remaining = ClaimManager.teamRemainingClaims.getOrDefault(ownerId, maxChunks2);
                        ClaimManager.teamRemainingClaims.put(ownerId, Math.max(remaining - chunkCount, 0));
                        break;
                    }
                    case PLAYER: {
                        UUID playerUuid = UUID.fromString(ownerId);
                        int maxChunks3 = CoreMain.plugin.getConfig().getInt("claims.player-max-chunk-claim-amount");
                        int remaining = ClaimManager.playerRemainingClaims.getOrDefault(playerUuid.toString(), maxChunks3);
                        ClaimManager.playerRemainingClaims.put(playerUuid.toString(), Math.max(remaining - chunkCount, 0));
                        break;
                    }
                }
            }
        }
    }
}

