/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.pane.component.util;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.InventoryComponent;
import net.mathias2246.buildmc.inventoryframework.pane.Flippable;
import net.mathias2246.buildmc.inventoryframework.pane.Orientable;
import net.mathias2246.buildmc.inventoryframework.pane.OutlinePane;
import net.mathias2246.buildmc.inventoryframework.pane.Pane;
import net.mathias2246.buildmc.inventoryframework.pane.util.Slot;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class VariableBar
extends Pane
implements Orientable,
Flippable {
    @NotNull
    protected final OutlinePane fillPane;
    @NotNull
    protected final OutlinePane backgroundPane;
    protected float value = 0.0f;
    @NotNull
    protected Orientable.Orientation orientation = Orientable.Orientation.HORIZONTAL;
    protected boolean flipHorizontally;
    protected boolean flipVertically;

    protected VariableBar(int length, int height, @NotNull Plugin plugin) {
        this(0, 0, length, height, plugin);
    }

    protected VariableBar(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority, @NotNull Plugin plugin) {
        super(slot, length, height);
        this.fillPane = new OutlinePane(0, 0, length, height);
        this.backgroundPane = new OutlinePane(0, 0, length, height);
        this.fillPane.addItem(new GuiItem(new ItemStack(Material.GREEN_STAINED_GLASS_PANE), event -> event.setCancelled(true), plugin));
        this.backgroundPane.addItem(new GuiItem(new ItemStack(Material.RED_STAINED_GLASS_PANE), event -> event.setCancelled(true), plugin));
        this.fillPane.setRepeat(true);
        this.backgroundPane.setRepeat(true);
        this.fillPane.setVisible(false);
        this.setPriority(priority);
    }

    protected VariableBar(int x, int y, int length, int height, @NotNull Pane.Priority priority, @NotNull Plugin plugin) {
        this(Slot.fromXY(x, y), length, height, priority, plugin);
    }

    protected VariableBar(@NotNull Slot slot, int length, int height, @NotNull Plugin plugin) {
        this(slot, length, height, Pane.Priority.NORMAL, plugin);
    }

    protected VariableBar(int x, int y, int length, int height, @NotNull Plugin plugin) {
        this(x, y, length, height, Pane.Priority.NORMAL, plugin);
    }

    protected VariableBar(int length, int height) {
        this(0, 0, length, height);
    }

    protected VariableBar(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority) {
        this(slot, length, height, priority, (Plugin)JavaPlugin.getProvidingPlugin(VariableBar.class));
    }

    protected VariableBar(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        this(x, y, length, height, priority, (Plugin)JavaPlugin.getProvidingPlugin(VariableBar.class));
    }

    protected VariableBar(@NotNull Slot slot, int length, int height) {
        this(slot, length, height, Pane.Priority.NORMAL);
    }

    protected VariableBar(int x, int y, int length, int height) {
        this(x, y, length, height, Pane.Priority.NORMAL);
    }

    protected void setValue(float value) {
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("Value is out of range (0,1)");
        }
        this.value = value;
        if (this.orientation == Orientable.Orientation.HORIZONTAL) {
            int length = Math.round((float)this.getLength() * value);
            boolean positiveLength = length != 0;
            this.fillPane.setVisible(positiveLength);
            if (positiveLength) {
                this.fillPane.setLength(length);
            }
            if (this.flipHorizontally) {
                this.fillPane.setX(this.getLength() - this.fillPane.getLength());
            }
        } else if (this.orientation == Orientable.Orientation.VERTICAL) {
            int height = Math.round((float)this.getHeight() * value);
            boolean positiveHeight = height != 0;
            this.fillPane.setVisible(positiveHeight);
            if (positiveHeight) {
                this.fillPane.setHeight(height);
            }
            if (this.flipVertically) {
                this.fillPane.setY(this.getHeight() - this.fillPane.getHeight());
            }
        } else {
            throw new UnsupportedOperationException("Unknown orientation");
        }
    }

    @Override
    public void setLength(int length) {
        super.setLength(length);
        if (this.orientation == Orientable.Orientation.HORIZONTAL) {
            int fillLength = Math.round((float)length * this.value);
            boolean positiveLength = fillLength != 0;
            this.fillPane.setVisible(positiveLength);
            if (positiveLength) {
                this.fillPane.setLength(fillLength);
            }
            if (this.flipHorizontally) {
                this.fillPane.setX(this.getLength() - this.fillPane.getLength());
            }
        } else if (this.orientation == Orientable.Orientation.VERTICAL) {
            this.fillPane.setLength(length);
        } else {
            throw new UnsupportedOperationException("Unknown orientation");
        }
        this.backgroundPane.setLength(length);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        if (this.orientation == Orientable.Orientation.HORIZONTAL) {
            this.fillPane.setHeight(height);
        } else if (this.orientation == Orientable.Orientation.VERTICAL) {
            int fillHeight = Math.round((float)height * this.value);
            boolean positiveHeight = fillHeight != 0;
            this.fillPane.setVisible(positiveHeight);
            if (positiveHeight) {
                this.fillPane.setHeight(fillHeight);
            }
            if (this.flipVertically) {
                this.fillPane.setY(this.getHeight() - this.fillPane.getHeight());
            }
        } else {
            throw new UnsupportedOperationException("Unknown orientation");
        }
        this.backgroundPane.setHeight(height);
    }

    protected void applyContents(@NotNull VariableBar copy) {
        copy.x = this.x;
        copy.y = this.y;
        copy.slot = this.slot;
        copy.length = this.length;
        copy.height = this.height;
        copy.setPriority(this.getPriority());
        copy.setVisible(this.isVisible());
        copy.onClick = this.onClick;
        copy.setFillItem(((GuiItem)this.fillPane.getItems().get(0)).copy());
        copy.setBackgroundItem(((GuiItem)this.backgroundPane.getItems().get(0)).copy());
        copy.value = this.value;
        copy.orientation = this.orientation;
        copy.flipHorizontally = this.flipHorizontally;
        copy.flipVertically = this.flipVertically;
        copy.uuid = this.uuid;
    }

    @Override
    public void setOrientation(@NotNull Orientable.Orientation orientation) {
        this.orientation = orientation;
        if (orientation == Orientable.Orientation.HORIZONTAL) {
            int fillLength = Math.round((float)this.getLength() * this.value);
            boolean positiveLength = fillLength != 0;
            this.fillPane.setVisible(fillLength != 0);
            if (positiveLength) {
                this.fillPane.setLength(fillLength);
            }
            this.fillPane.setHeight(this.getHeight());
        } else if (orientation == Orientable.Orientation.VERTICAL) {
            int fillHeight = Math.round((float)this.getHeight() * this.value);
            boolean positiveHeight = fillHeight != 0;
            this.fillPane.setVisible(fillHeight != 0);
            this.fillPane.setLength(this.getLength());
            if (positiveHeight) {
                this.fillPane.setHeight(fillHeight);
            }
        } else {
            throw new IllegalArgumentException("Unknown orientation");
        }
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        Slot slot = this.getSlot();
        int newPaneOffsetX = paneOffsetX + slot.getX(maxLength);
        int newPaneOffsetY = paneOffsetY + slot.getY(maxLength);
        int newMaxLength = Math.min(maxLength, this.getLength());
        int newMaxHeight = Math.min(maxHeight, this.getHeight());
        if (this.backgroundPane.isVisible()) {
            this.backgroundPane.display(inventoryComponent, newPaneOffsetX, newPaneOffsetY, newMaxLength, newMaxHeight);
        }
        if (this.fillPane.isVisible()) {
            this.fillPane.display(inventoryComponent, newPaneOffsetX, newPaneOffsetY, newMaxLength, newMaxHeight);
        }
    }

    public void setFillItem(@NotNull GuiItem item) {
        this.fillPane.clear();
        this.fillPane.addItem(item);
    }

    public void setBackgroundItem(@NotNull GuiItem item) {
        this.backgroundPane.clear();
        this.backgroundPane.addItem(item);
    }

    @Override
    @NotNull
    public Collection<GuiItem> getItems() {
        return this.getPanes().stream().flatMap(pane -> pane.getItems().stream()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<Pane> getPanes() {
        return Stream.of(this.fillPane, this.backgroundPane).collect(Collectors.toSet());
    }

    @Override
    public void flipHorizontally(boolean flipHorizontally) {
        this.flipHorizontally = flipHorizontally;
    }

    @Override
    public void flipVertically(boolean flipVertically) {
        this.flipVertically = flipVertically;
    }

    @Override
    @NotNull
    public Orientable.Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public boolean isFlippedHorizontally() {
        return this.flipHorizontally;
    }

    @Override
    public boolean isFlippedVertically() {
        return this.flipVertically;
    }

    @Override
    public void clear() {
    }
}

