/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.spawnElytra;

import java.util.Objects;
import net.mathias2246.buildmc.Main;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class SpawnBoostRunnable {
    public final int multiplyValue;
    public final Player player;
    @NotNull
    public static final NamespacedKey USES_SPAWN_ELYTRA_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:uses_spawn_elytra"));
    @NotNull
    public static final NamespacedKey USES_SPAWN_ELYTRA_BOOST_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:uses_spawn_elytra_boost"));

    public static boolean isUsingSpawnElytra(@NotNull Player player) {
        return player.getPersistentDataContainer().has(USES_SPAWN_ELYTRA_KEY);
    }

    public static boolean isUsingSpawnElytra(@NotNull Entity entity) {
        return entity.getPersistentDataContainer().has(USES_SPAWN_ELYTRA_KEY);
    }

    public static boolean isPlayerBoosted(@NotNull Player player) {
        return player.getPersistentDataContainer().has(USES_SPAWN_ELYTRA_BOOST_KEY);
    }

    public static boolean isPlayerBoosted(@NotNull Entity entity) {
        return entity.getPersistentDataContainer().has(USES_SPAWN_ELYTRA_BOOST_KEY);
    }

    public static void resetBoost(@NotNull Player player) {
        player.getPersistentDataContainer().remove(USES_SPAWN_ELYTRA_BOOST_KEY);
    }

    public static void resetBoost(@NotNull Entity entity) {
        entity.getPersistentDataContainer().remove(USES_SPAWN_ELYTRA_BOOST_KEY);
    }

    public static boolean isSurvival(@NotNull Player player) {
        return player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE;
    }

    public static boolean isSurvival(@NotNull GameMode gameMode) {
        return gameMode == GameMode.SURVIVAL || gameMode == GameMode.ADVENTURE;
    }

    public static void stopFlying(@NotNull Player player) {
        player.getPersistentDataContainer().remove(USES_SPAWN_ELYTRA_BOOST_KEY);
        player.getPersistentDataContainer().remove(USES_SPAWN_ELYTRA_KEY);
        player.setFallDistance(0.0f);
        if (SpawnBoostRunnable.isSurvival(player)) {
            player.setAllowFlight(false);
        }
        player.setFlying(false);
        player.setGliding(false);
    }

    public static void setPlayerFlying(@NotNull Player player) {
        GameMode mode = player.getGameMode();
        if (!SpawnBoostRunnable.isSurvival(player)) {
            return;
        }
        player.setGliding(true);
        player.setAllowFlight(false);
        player.setFlying(false);
        player.getPersistentDataContainer().set(USES_SPAWN_ELYTRA_KEY, PersistentDataType.BOOLEAN, (Object)true);
    }

    public SpawnBoostRunnable(Player player) {
        this.player = player;
        this.multiplyValue = Main.config.getInt("spawn-elytra.strength", 2);
        boolean boostEnabled = Main.config.getBoolean("spawn-elytra.enabled", true);
    }

    public static void applyBoost(@NotNull Player player, double multiplier, double verticalVelocity) {
        player.getPersistentDataContainer().set(USES_SPAWN_ELYTRA_BOOST_KEY, PersistentDataType.BOOLEAN, (Object)true);
        SpawnBoostRunnable.applyRawBoost(player, multiplier, verticalVelocity);
    }

    public static void applyRawBoost(@NotNull Player player, double multiplier, double verticalVelocity) {
        player.setVelocity(player.getLocation().getDirection().multiply(multiplier).setY(verticalVelocity));
    }
}

