/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.status;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.mathias2246.buildmc.claims.ClaimManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializableAs(value="StatusInstance")
public class StatusInstance
implements ConfigurationSerializable {
    @NotNull
    private final String statusId;
    @Nullable
    private final Set<Permission> permissions;
    @Nullable
    private final Set<Team> teams;
    @NotNull
    private final Component display;
    private final boolean hasRequirements;

    @NotNull
    public Component getDisplay() {
        return this.display;
    }

    @NotNull
    public String getStatusId() {
        return this.statusId;
    }

    @Nullable
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    @Nullable
    public Set<Team> getTeams() {
        return this.teams;
    }

    public StatusInstance(@NotNull String statusId, @Nullable Set<Permission> permissions, @Nullable Set<Team> teams, @Nullable Component display) {
        this.statusId = statusId;
        this.permissions = permissions;
        this.teams = teams;
        this.hasRequirements = permissions != null || teams != null;
        this.display = display == null ? Component.text("null") : display;
    }

    public AllowStatus allowPlayer(Player player) {
        if (player == null) {
            return AllowStatus.NOT_ALLOWED;
        }
        if (!this.hasRequirements) {
            return AllowStatus.ALLOW;
        }
        boolean allow = false;
        if (this.permissions != null) {
            for (Permission p : this.permissions) {
                if (!player.hasPermission(p)) continue;
                allow = true;
                break;
            }
        } else {
            allow = true;
        }
        if (!allow) {
            return AllowStatus.MISSING_PERMISSION;
        }
        if (this.teams != null) {
            Team team = ClaimManager.getPlayerTeam(player);
            if (team == null) {
                return AllowStatus.NOT_IN_TEAM;
            }
            for (Team t : this.teams) {
                if (!team.equals((Object)t)) continue;
                return AllowStatus.ALLOW;
            }
            return AllowStatus.NOT_IN_TEAM;
        }
        return AllowStatus.ALLOW;
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("statusId", this.statusId);
        if (this.permissions != null) {
            map.put("permissions", this.permissions.stream().map(Permission::getName).collect(Collectors.toList()));
        }
        if (this.teams != null) {
            map.put("teams", this.teams.stream().map(Team::getName).collect(Collectors.toList()));
        }
        map.put("display-name", MiniMessage.miniMessage().serialize(this.display));
        return map;
    }

    public static StatusInstance deserialize(Map<String, Object> map) {
        Object object;
        Object object2;
        Object object3;
        String statusId = (String)map.get("statusId");
        Set<Permission> perms = null;
        if (map.containsKey("permissions") && (object3 = map.get("permissions")) instanceof List) {
            List permNames = (List)object3;
            perms = permNames.stream().map(s -> new Permission((String)s)).collect(Collectors.toSet());
        }
        Set teams = null;
        if (map.containsKey("teams") && (object2 = map.get("teams")) instanceof List) {
            List teamNames = (List)object2;
            teams = teamNames.stream().map(name -> Objects.requireNonNull(Objects.requireNonNull(Bukkit.getScoreboardManager()).getMainScoreboard().getTeam((String)name))).collect(Collectors.toSet());
        }
        Component display = null;
        if (map.containsKey("display-name") && (object = map.get("display-name")) instanceof String) {
            String s2 = (String)object;
            display = (Component)MiniMessage.miniMessage().deserialize(s2);
        }
        return new StatusInstance(statusId, perms, teams, display);
    }

    public static enum AllowStatus {
        ALLOW,
        NOT_ALLOWED,
        MISSING_PERMISSION,
        NOT_IN_TEAM;

    }
}

