/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.util.language;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslationStore;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.Translator;
import net.mathias2246.buildmc.CoreMain;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public class LanguageManager {
    private static final Locale DEFAULT_LOCALE = Locale.forLanguageTag("en-US");
    private static final List<String> DEFAULT_FILES = List.of("en-US.yml", "de-DE.yml");
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final File LANG_FOLDER;
    private static final Key TRANSLATOR_KEY;
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        LanguageManager.loadLanguages();
    }

    private static void loadLanguages() {
        LanguageManager.ensureDefaultLanguageFiles();
        File[] files = LANG_FOLDER.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            return;
        }
        MiniMessageTranslationStore store = MiniMessageTranslationStore.create(TRANSLATOR_KEY);
        for (File file : files) {
            try (FileReader reader = new FileReader(file);){
                Yaml yaml = new Yaml();
                Map yamlData = (Map)yaml.load((Reader)reader);
                if (yamlData == null) continue;
                Locale locale = LanguageManager.toLocale(file.getName());
                LanguageManager.flatten("", yamlData).forEach((key, value) -> {
                    if (value instanceof String) {
                        String str = (String)value;
                        store.register((String)key, locale, str);
                    }
                });
                GlobalTranslator.translator().addSource(store);
                CoreMain.plugin.getLogger().info("Loaded language file: " + file.getName());
            }
            catch (Exception e) {
                CoreMain.plugin.getLogger().log(Level.SEVERE, "Failed to load language file: " + file.getName(), e);
            }
        }
    }

    private static void ensureDefaultLanguageFiles() {
        for (String fileName : DEFAULT_FILES) {
            File targetFile = new File(LANG_FOLDER, fileName);
            if (targetFile.exists()) continue;
            try {
                InputStream in = CoreMain.class.getResourceAsStream("/lang/" + fileName);
                try {
                    if (in != null) {
                        Files.copy(in, targetFile.toPath(), new CopyOption[0]);
                        continue;
                    }
                    CoreMain.plugin.getLogger().warning("Default language file not found in JAR: " + fileName);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (Exception e) {
                CoreMain.plugin.getLogger().log(Level.SEVERE, "Failed to copy default language file: " + fileName, e);
            }
        }
    }

    private static Locale toLocale(String filename) {
        String baseName = filename.replace(".yml", "").replace('_', '-');
        return Locale.forLanguageTag(baseName);
    }

    private static Map<String, Object> flatten(String prefix, Map<?, ?> input) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        input.forEach((key, value) -> {
            String fullKey;
            String string = fullKey = prefix.isEmpty() ? key.toString() : prefix + "." + String.valueOf(key);
            if (value instanceof Map) {
                Map nested = (Map)value;
                map.putAll(LanguageManager.flatten(fullKey, nested));
            } else {
                map.put(fullKey, value);
            }
        });
        return map;
    }

    public static Component translate(@NotNull Locale playerLocale, @NotNull String key, @NotNull Map<String, String> replacements, Component ... args) {
        TranslatableComponent base = Component.translatable(key, Arrays.asList(args));
        Component translated = GlobalTranslator.render(base, playerLocale);
        if (translated.equals(base)) {
            translated = GlobalTranslator.render(base, DEFAULT_LOCALE);
        }
        String serialized = (String)MINI_MESSAGE.serialize(translated);
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            serialized = serialized.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return MINI_MESSAGE.deserialize(serialized);
    }

    public static String translateStr(@NotNull Locale playerLocale, @NotNull String key, @NotNull Map<String, String> replacements, Component ... args) {
        TranslatableComponent base = Component.translatable(key, Arrays.asList(args));
        Component translated = GlobalTranslator.render(base, playerLocale);
        if (translated.equals(base)) {
            translated = GlobalTranslator.render(base, DEFAULT_LOCALE);
        }
        String serialized = (String)MINI_MESSAGE.serialize(translated);
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            serialized = serialized.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return serialized;
    }

    public static Translator getTranslator() {
        return GlobalTranslator.translator();
    }

    static {
        TRANSLATOR_KEY = Key.key("buildmc:lang");
        initialized = false;
        LANG_FOLDER = new File(CoreMain.plugin.getDataFolder(), "lang");
        if (!LANG_FOLDER.exists() && !LANG_FOLDER.mkdirs()) {
            CoreMain.plugin.getLogger().severe("Could not create language folder: " + LANG_FOLDER.getPath());
        }
    }
}

