/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimDataInstance
implements ConfigurationSerializable {
    @NotNull
    public final List<UUID> whitelistedPlayers = new ArrayList<UUID>();
    public int chunksLeft;
    public static int defaultChunksLeftAmount = -1;

    public ClaimDataInstance() {
    }

    public ClaimDataInstance(@Nullable Integer chunksLeft) {
        this.chunksLeft = chunksLeft == null ? defaultChunksLeftAmount : chunksLeft;
    }

    public ClaimDataInstance(List<String> uuidStrings, int chunksLeft) {
        for (String uuid : uuidStrings) {
            this.whitelistedPlayers.add(UUID.fromString(uuid));
        }
        this.chunksLeft = chunksLeft;
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList<String> uuidStrings = new ArrayList<String>();
        for (UUID uuid : this.whitelistedPlayers) {
            uuidStrings.add(uuid.toString());
        }
        map.put("whitelist", uuidStrings);
        map.put("chunks-left", this.chunksLeft);
        return map;
    }

    public static ClaimDataInstance deserialize(Map<String, Object> map) {
        List whitelist = map.getOrDefault("whitelist", new ArrayList());
        int chunks = (Integer)map.getOrDefault("chunks-left", defaultChunksLeftAmount);
        return new ClaimDataInstance(whitelist, chunks);
    }
}

