/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.util;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationManager {
    private final Plugin plugin;
    private File configFile;
    @NotNull
    private final String resourceName;
    public final FileConfiguration configuration;

    public Plugin getPlugin() {
        return this.plugin;
    }

    public ConfigurationManager(@NotNull Plugin plugin, @NotNull String resourceName) {
        this.plugin = plugin;
        this.resourceName = resourceName;
        this.configFile = new File(plugin.getDataFolder(), resourceName);
        this.saveFromResource();
        this.configuration = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.setupConfiguration();
    }

    public void reload() {
        try {
            this.configuration.load(this.configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.setupConfiguration();
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(@NotNull File file) {
        this.configFile = file;
        try {
            this.load();
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() throws IOException {
        this.preSave();
        this.configuration.save(this.configFile);
    }

    public abstract void setupConfiguration();

    private void load() throws IOException, InvalidConfigurationException {
        this.configuration.load(this.configFile);
        this.setupConfiguration();
    }

    protected abstract void preSave();

    public void saveFromResource() {
        if (!this.configFile.exists()) {
            this.plugin.saveResource(this.resourceName, false);
        }
    }
}

