/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.util;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.util.language.LanguageManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Message {
    private static final Locale DEFAULT_LOCALE = Locale.forLanguageTag("en-US");

    private static Locale getLocale(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return Locale.forLanguageTag(player.locale().toLanguageTag().replace('_', '-'));
        }
        return DEFAULT_LOCALE;
    }

    private static Locale getLocale(Player player) {
        return Locale.forLanguageTag(player.locale().toLanguageTag().replace('_', '-'));
    }

    public static Component msg(Player player, String key) {
        return Message.msg(player, key, Collections.emptyMap());
    }

    public static Component msg(Player player, String key, Map<String, String> placeholders) {
        return LanguageManager.translate(Message.getLocale(player), key, placeholders, new Component[0]);
    }

    public static Component errorMsg(Player player, String errorMessage) {
        return Message.msg(player, "messages.error.general", Map.of("error_message", errorMessage));
    }

    public static Component permissionErrorMsg(Player player) {
        return Message.msg(player, "messages.error.no-permission");
    }

    public static Component noPlayerErrorMsg(Player player) {
        return Message.msg(player, "messages.error.not-a-player");
    }

    public static Component msg(CommandSender sender, String key) {
        return Message.msg(sender, key, Collections.emptyMap());
    }

    public static Component msg(CommandSender sender, String key, Map<String, String> placeholders) {
        return LanguageManager.translate(Message.getLocale(sender), key, placeholders, new Component[0]);
    }

    public static Component errorMsg(CommandSender sender, String errorMessage) {
        return Message.msg(sender, "messages.error.general", Map.of("error_message", errorMessage));
    }

    public static Component permissionErrorMsg(CommandSender sender) {
        return Message.msg(sender, "messages.error.no-permission");
    }

    public static Component noPlayerErrorMsg(CommandSender sender) {
        return Message.msg(sender, "messages.error.not-a-player");
    }

    public static String msgStr(Player player, String key) {
        return Message.msgStr(player, key, Collections.emptyMap());
    }

    public static String msgStr(Player player, String key, Map<String, String> placeholders) {
        return LanguageManager.translateStr(Message.getLocale(player), key, placeholders, new Component[0]);
    }

    public static String errorMsgStr(Player player, String errorMessage) {
        return Message.msgStr(player, "messages.error.general", Map.of("error_message", errorMessage));
    }

    public static String permissionErrorMsgStr(Player player) {
        return Message.msgStr(player, "messages.error.no-permission");
    }

    public static String noPlayerErrorMsgStr(Player player) {
        return Message.msgStr(player, "messages.error.not-a-player");
    }

    public static String msgStr(CommandSender sender, String key) {
        return Message.msgStr(sender, key, Collections.emptyMap());
    }

    public static String msgStr(CommandSender sender, String key, Map<String, String> placeholders) {
        return LanguageManager.translateStr(Message.getLocale(sender), key, placeholders, new Component[0]);
    }

    public static String errorMsgStr(CommandSender sender, String errorMessage) {
        return Message.msgStr(sender, "messages.error.general-str", Map.of("error_message", errorMessage));
    }

    public static String permissionErrorMsgStr(CommandSender sender) {
        return Message.msgStr(sender, "messages.error.no-permission-str");
    }

    public static String noPlayerErrorMsgStr(CommandSender sender) {
        return Message.msgStr(sender, "messages.error.not-a-player-str");
    }
}

