/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Logger;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.mathias2246.buildmc.claims.ClaimBreakListener;
import net.mathias2246.buildmc.claims.ClaimBucketUseEvent;
import net.mathias2246.buildmc.claims.ClaimCommand;
import net.mathias2246.buildmc.claims.ClaimContainerListener;
import net.mathias2246.buildmc.claims.ClaimDamageProtectionListener;
import net.mathias2246.buildmc.claims.ClaimDataInstance;
import net.mathias2246.buildmc.claims.ClaimDataSaveListener;
import net.mathias2246.buildmc.claims.ClaimEntityChangeBlockListener;
import net.mathias2246.buildmc.claims.ClaimExplosionsListener;
import net.mathias2246.buildmc.claims.ClaimFrostWalkerListener;
import net.mathias2246.buildmc.claims.ClaimInteractionListener;
import net.mathias2246.buildmc.claims.ClaimItemDropListener;
import net.mathias2246.buildmc.claims.ClaimItemPickupListener;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.claims.ClaimPistonMovementListener;
import net.mathias2246.buildmc.claims.ClaimPlaceListener;
import net.mathias2246.buildmc.claims.ClaimPotionSplashEvent;
import net.mathias2246.buildmc.claims.ClaimSignEditListener;
import net.mathias2246.buildmc.claims.ClaimTool;
import net.mathias2246.buildmc.claims.ClaimVehicleEnterListener;
import net.mathias2246.buildmc.commandAPI.CommandAPI;
import net.mathias2246.buildmc.commands.BuildMcCommand;
import net.mathias2246.buildmc.commands.CommandRegister;
import net.mathias2246.buildmc.endEvent.EndListener;
import net.mathias2246.buildmc.spawnElytra.DisableRocketListener;
import net.mathias2246.buildmc.spawnElytra.ElytraZoneCommand;
import net.mathias2246.buildmc.spawnElytra.ElytraZoneManager;
import net.mathias2246.buildmc.spawnElytra.SpawnBoostListener;
import net.mathias2246.buildmc.status.PlayerStatus;
import net.mathias2246.buildmc.status.SetStatusCommand;
import net.mathias2246.buildmc.status.StatusConfig;
import net.mathias2246.buildmc.util.Message;
import net.mathias2246.buildmc.util.Sounds;
import net.mathias2246.buildmc.util.language.LanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public final class Main
extends JavaPlugin {
    public static Logger logger;
    public static Plugin plugin;
    @Subst(value="")
    public static FileConfiguration config;
    public static File configFile;
    public static File pluginFolder;
    private static final ElytraZoneManager zoneManager;
    public static StatusConfig statusConfig;
    public static BukkitAudiences audiences;
    public static ClaimManager claimManager;

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        pluginFolder = plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdir();
        }
        LanguageManager.init();
        configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveResource("config.yml", false);
        }
        config = this.getConfig();
        audiences = BukkitAudiences.create(plugin);
        EndListener.loadFromConfig();
        Sounds.setup();
        ClaimTool.setup();
        CommandRegister.setupCommandAPI();
        CommandRegister.register(new BuildMcCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new EndListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClaimTool(), (Plugin)this);
        if (config.getBoolean("spawn-elytra.enabled")) {
            this.getServer().getPluginManager().registerEvents((Listener)new SpawnBoostListener(zoneManager), (Plugin)this);
            if (config.getBoolean("spawn-elytra.disable-rockets")) {
                this.getServer().getPluginManager().registerEvents((Listener)new DisableRocketListener(), (Plugin)this);
            }
            CommandRegister.register(new ElytraZoneCommand(zoneManager));
            zoneManager.loadZoneFromConfig();
        }
        if (config.getBoolean("claims.enabled")) {
            CommandRegister.register(new ClaimCommand());
            ClaimDataInstance.defaultChunksLeftAmount = config.getInt("claims.max-chunk-claim-amount", 1600);
            claimManager = new ClaimManager((Plugin)this, "claim-data.yml");
            if (config.getBoolean("claims.protections.containers")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimContainerListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.damage.explosion-block-damage") || config.getBoolean("claims.protections.explosion-entity-damage")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimExplosionsListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.player-break")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimBreakListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.player-place")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimPlaceListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.damage.entity-damage")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimDamageProtectionListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.sign-editing")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimSignEditListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.prevent-interactions")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimInteractionListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.splash-potions")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimPotionSplashEvent(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.vehicle-enter")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimVehicleEnterListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.bucket-usage")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimBucketUseEvent(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.prevent-entity-modifications")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimEntityChangeBlockListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.item-pickup")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimItemPickupListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.item-drop")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimItemDropListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.frostwalker")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimFrostWalkerListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.protections.piston-movement-across-claim-borders")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimPistonMovementListener(), (Plugin)this);
            }
            if (config.getBoolean("claims.save-on-world-save")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimDataSaveListener(claimManager), (Plugin)this);
            }
        }
        if (config.getBoolean("status.enabled")) {
            statusConfig = new StatusConfig((Plugin)this);
            CommandRegister.register(new SetStatusCommand(statusConfig));
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerStatus(), (Plugin)this);
        }
        if (config.getBoolean("disable-commands") && config.isList("disabled-commands")) {
            for (String fullCommand : config.getStringList("disabled-commands")) {
                String[] parts = fullCommand.split(":", 2);
                if (parts.length == 2) {
                    this.disableCommand(parts[0], parts[1]);
                    continue;
                }
                logger.warning("Invalid command format in 'disabled-commands': " + fullCommand);
            }
        }
    }

    public void onDisable() {
        audiences.close();
        CommandAPI.onDisable();
        try {
            claimManager.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void disableCommand(String namespace, String commandName) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            if (!(commandMap instanceof SimpleCommandMap)) {
                logger.warning("Unsupported CommandMap implementation. Cannot disable command: " + commandName);
                return;
            }
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            Map knownCommands = (Map)knownCommandsField.get(commandMap);
            knownCommands.keySet().removeIf(key -> key.equalsIgnoreCase(commandName) || key.equalsIgnoreCase(namespace + ":" + commandName) || key.endsWith(":" + commandName));
            Command blockedCommand = new Command(this, commandName){

                public boolean execute(@NotNull CommandSender sender, @NotNull String label, String[] args) {
                    audiences.sender(sender).sendMessage(Message.msg(sender, "messages.error.command-disabled"));
                    return true;
                }
            };
            commandMap.register(namespace, blockedCommand);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.warning("Failed to fully disable command '" + commandName + "': " + e.getMessage());
        }
    }

    private CommandMap getCommandMap() {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            return (CommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            logger.warning("Failed to retrieve the command map.");
            return null;
        }
    }

    static {
        zoneManager = new ElytraZoneManager();
    }
}

