/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.claims.ClaimManager;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class ClaimContainerListener
implements Listener {
    private final boolean allowEnderChests = Main.config.getBoolean("claims.protections.allow-ender-chests");

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onOpenContainer(InventoryOpenEvent event) {
        HumanEntity player = event.getPlayer();
        if (event.getInventory().getType() == InventoryType.ENDER_CHEST) {
            if (this.allowEnderChests) {
                return;
            }
            Main.audiences.player((Player)player).sendActionBar(Component.translatable("messages.claims.not-accessible.container"));
            event.setCancelled(true);
            return;
        }
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof BlockState) {
            BlockState holder = (BlockState)inventoryHolder;
            if (!ClaimManager.isPlayerAllowed(Main.claimManager, player, holder.getLocation())) {
                Main.audiences.player((Player)player).sendActionBar(Component.translatable("messages.claims.not-accessible.container"));
                event.setCancelled(true);
            }
        } else {
            inventoryHolder = event.getInventory().getHolder();
            if (inventoryHolder instanceof Entity) {
                Entity entity = (Entity)inventoryHolder;
                if (!ClaimManager.isPlayerAllowed(Main.claimManager, player, entity.getLocation())) {
                    Main.audiences.player((Player)player).sendActionBar(Component.translatable("messages.claims.not-accessible.entity-container"));
                    event.setCancelled(true);
                }
            } else if (!ClaimManager.isPlayerAllowed(Main.claimManager, player, player.getLocation())) {
                Main.audiences.player((Player)player).sendActionBar(Component.translatable("messages.claims.not-accessible.container"));
                event.setCancelled(true);
            }
        }
    }
}

