/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.mathias2246.buildmc.claims.ClaimDataInstance;
import net.mathias2246.buildmc.util.ConfigurationManager;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimManager
extends ConfigurationManager {
    @NotNull
    public static final NamespacedKey CLAIM_PCD_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:claim_owner"));
    public Map<String, ClaimDataInstance> claims;

    @NotNull
    public ClaimDataInstance getEntryOrNew(@NotNull Team team) {
        this.claims.putIfAbsent(team.getName(), new ClaimDataInstance(null));
        return this.claims.get(team.getName());
    }

    public ClaimManager(@NotNull Plugin plugin, @NotNull String resourceName) {
        super(plugin, resourceName);
    }

    @Override
    public void setupConfiguration() {
        this.claims = new HashMap<String, ClaimDataInstance>();
        for (String key : this.configuration.getKeys(false)) {
            ConfigurationSection sect = this.configuration.getConfigurationSection(key);
            if (sect == null) {
                return;
            }
            Team team = Objects.requireNonNull(this.getPlugin().getServer().getScoreboardManager()).getMainScoreboard().getTeam(key);
            if (team == null) continue;
            ClaimDataInstance v = ClaimDataInstance.deserialize(sect.getValues(false));
            this.claims.putIfAbsent(team.getName(), v);
        }
    }

    @Override
    protected void preSave() {
        for (Map.Entry<String, ClaimDataInstance> entry : this.claims.entrySet()) {
            this.configuration.set(entry.getKey(), entry.getValue().serialize());
        }
    }

    public static boolean isPlayerWhitelisted(@NotNull ClaimManager manager, Team team, @NotNull Player player) {
        if (team == null) {
            return false;
        }
        ClaimDataInstance l = manager.getEntryOrNew(team);
        return l.whitelistedPlayers.contains(player.getUniqueId());
    }

    public static boolean isPlayerWhitelisted(@NotNull ClaimManager manager, Team team, @NotNull HumanEntity player) {
        if (team == null) {
            return false;
        }
        ClaimDataInstance l = manager.getEntryOrNew(team);
        return l.whitelistedPlayers.contains(player.getUniqueId());
    }

    public static void setPlayerWhitelisted(@NotNull ClaimManager manager, @NotNull Team team, @NotNull Player player) {
        List<UUID> t = manager.getEntryOrNew((Team)team).whitelistedPlayers;
        UUID uuid = player.getUniqueId();
        t.add(uuid);
        String tn = team.getName();
    }

    public static void removePlayerWhitelisted(@NotNull ClaimManager manager, @NotNull Team team, @NotNull Player player) {
        ClaimDataInstance t = manager.getEntryOrNew(team);
        t.whitelistedPlayers.remove(player.getUniqueId());
    }

    public static void forceClaimChunk(@Nullable Team team, @NotNull Location location) {
        if (team == null) {
            location.getChunk().getPersistentDataContainer().remove(CLAIM_PCD_KEY);
            return;
        }
        location.getChunk().getPersistentDataContainer().set(CLAIM_PCD_KEY, PersistentDataType.STRING, (Object)team.getName());
    }

    public static void forceClaimChunk(@Nullable Team team, @NotNull Chunk chunk) {
        if (team == null) {
            chunk.getPersistentDataContainer().remove(CLAIM_PCD_KEY);
            return;
        }
        chunk.getPersistentDataContainer().set(CLAIM_PCD_KEY, PersistentDataType.STRING, (Object)team.getName());
    }

    @Nullable
    public static String getOwnerString(@NotNull Location location) {
        return ClaimManager.getOwnerString(location.getChunk());
    }

    @Nullable
    public static String getOwnerString(@NotNull Chunk chunk) {
        if (!chunk.getPersistentDataContainer().has(CLAIM_PCD_KEY, PersistentDataType.STRING)) {
            return null;
        }
        return (String)chunk.getPersistentDataContainer().get(CLAIM_PCD_KEY, PersistentDataType.STRING);
    }

    public static boolean hasOwner(@NotNull Chunk chunk) {
        return chunk.getPersistentDataContainer().has(CLAIM_PCD_KEY);
    }

    public static boolean isNotClaimedOrOwn(Team team, @NotNull Location location) {
        Team c = ClaimManager.getClaimTeam(location);
        return Objects.equals(team, c) || c == null;
    }

    public static boolean isNotClaimedOrOwn(Team team, @NotNull Chunk chunk) {
        Team c = ClaimManager.getClaimTeam(chunk);
        return Objects.equals(team, c) || c == null;
    }

    public static boolean isNotClaimedOrOwn(@NotNull Player player, @NotNull Chunk chunk) {
        Team c = ClaimManager.getClaimTeam(chunk);
        return Objects.equals(ClaimManager.getPlayerTeam(player), c) || c == null;
    }

    public static boolean isNotClaimedOrOwn(@NotNull HumanEntity player, @NotNull Chunk chunk) {
        Team c = ClaimManager.getClaimTeam(chunk);
        return Objects.equals(ClaimManager.getPlayerTeam((Player)player), c) || c == null;
    }

    @Nullable
    public static Team getPlayerTeam(@NotNull Player player) {
        return player.getScoreboard().getEntryTeam(player.getName());
    }

    @Nullable
    public static Team getClaimTeam(@NotNull Location location) {
        String owner = ClaimManager.getOwnerString(location);
        if (owner == null) {
            return null;
        }
        return Objects.requireNonNull(Bukkit.getScoreboardManager()).getMainScoreboard().getTeam(owner);
    }

    @Nullable
    public static Team getClaimTeam(@NotNull Chunk chunk) {
        String owner = ClaimManager.getOwnerString(chunk);
        if (owner == null) {
            return null;
        }
        return Objects.requireNonNull(Bukkit.getScoreboardManager()).getMainScoreboard().getTeam(owner);
    }

    public static boolean isPlayerAllowed(@NotNull ClaimManager manager, @NotNull Player player, @NotNull Location location) {
        return ClaimManager.isNotClaimedOrOwn(player, location.getChunk()) || ClaimManager.isPlayerWhitelisted(manager, ClaimManager.getClaimTeam(location), player);
    }

    public static boolean isPlayerAllowed(@NotNull ClaimManager manager, @NotNull HumanEntity player, @NotNull Location location) {
        return ClaimManager.isNotClaimedOrOwn(player, location.getChunk()) || ClaimManager.isPlayerWhitelisted(manager, ClaimManager.getClaimTeam(location), player);
    }

    public static void forceClaimArea(Team team, @NotNull Location from, @NotNull Location to) {
        if (!Objects.equals(from.getWorld(), to.getWorld())) {
            return;
        }
        for (int z = from.getChunk().getZ(); z <= to.getChunk().getZ(); ++z) {
            for (int x = from.getChunk().getX(); x <= to.getChunk().getX(); ++x) {
                Chunk chunk = Objects.requireNonNull(from.getWorld()).getChunkAt(x, z);
                ClaimManager.forceClaimChunk(team, chunk);
            }
        }
    }

    public static void forceClaimArea(Team team, @NotNull World world, int startX, int startZ, int endX, int endZ) {
        for (int z = startZ; z <= endZ; ++z) {
            for (int x = startX; x <= endX; ++x) {
                Chunk chunk = world.getChunkAt(x, z);
                ClaimManager.forceClaimChunk(team, chunk);
            }
        }
    }

    public static int getChunksLeft(@NotNull ClaimManager manager, @NotNull Team team) {
        ClaimDataInstance t = manager.getEntryOrNew(team);
        return t.chunksLeft;
    }
}

