/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import java.util.List;
import net.mathias2246.buildmc.claims.ClaimManager;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class ClaimPistonMovementListener
implements Listener {
    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        Block piston = event.getBlock();
        String pistonOwner = ClaimManager.getOwnerString(piston.getChunk());
        BlockFace direction = event.getDirection();
        List movedBlocks = event.getBlocks();
        for (Block movedBlock : movedBlocks) {
            String toOwner;
            Block destinationBlock = movedBlock.getRelative(direction);
            String fromOwner = ClaimManager.getOwnerString(movedBlock.getChunk());
            if (!this.equalsOrNull(fromOwner, toOwner = ClaimManager.getOwnerString(destinationBlock.getChunk()))) {
                event.setCancelled(true);
                return;
            }
            if (!this.equalsOrNull(pistonOwner, toOwner)) {
                event.setCancelled(true);
                return;
            }
            if (this.equalsOrNull(pistonOwner, fromOwner)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (!event.isSticky()) {
            return;
        }
        Block piston = event.getBlock();
        String pistonOwner = ClaimManager.getOwnerString(piston.getChunk());
        BlockFace direction = event.getDirection();
        Block blockToPull = piston.getRelative(direction.getOppositeFace()).getRelative(direction.getOppositeFace());
        Block pullDestination = blockToPull.getRelative(direction);
        String pulledBlockOwner = ClaimManager.getOwnerString(blockToPull.getChunk());
        String destinationOwner = ClaimManager.getOwnerString(pullDestination.getChunk());
        if (!this.equalsOrNull(pistonOwner, pulledBlockOwner)) {
            event.setCancelled(true);
            return;
        }
        if (!this.equalsOrNull(pistonOwner, destinationOwner)) {
            event.setCancelled(true);
            return;
        }
        if (!this.equalsOrNull(pulledBlockOwner, destinationOwner)) {
            event.setCancelled(true);
        }
    }

    private boolean equalsOrNull(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

