/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.MainClass;
import net.mathias2246.buildmc.claims.ClaimCommand;
import net.mathias2246.buildmc.claims.ClaimDataInstance;
import net.mathias2246.buildmc.claims.ClaimDataSaveListener;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.claims.ClaimTool;
import net.mathias2246.buildmc.commands.BuildMcCommand;
import net.mathias2246.buildmc.endEvent.EndListener;
import net.mathias2246.buildmc.player.PlayerHeadDropDeathListener;
import net.mathias2246.buildmc.player.PlayerHeadDropModifier;
import net.mathias2246.buildmc.spawnElytra.DisableBoostListener;
import net.mathias2246.buildmc.spawnElytra.ElytraZoneManager;
import net.mathias2246.buildmc.spawnElytra.SpawnBoostListener;
import net.mathias2246.buildmc.status.PlayerStatus;
import net.mathias2246.buildmc.status.SetStatusCommand;
import net.mathias2246.buildmc.status.StatusConfig;
import net.mathias2246.buildmc.util.Message;
import net.mathias2246.buildmc.util.Sounds;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main
extends JavaPlugin
implements MainClass {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    public static java.util.logging.Logger logger;
    public static Plugin plugin;
    @Subst(value="")
    public static FileConfiguration config;
    public static File configFile;
    public static File pluginFolder;
    public static final ElytraZoneManager zoneManager;
    public static StatusConfig statusConfig;
    public static ClaimManager claimManager;

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        pluginFolder = plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdir();
        }
        if (!(configFile = new File(plugin.getDataFolder(), "config.yml")).exists()) {
            this.saveResource("config.yml", false);
        }
        config = this.getConfig();
        CoreMain.initialize((Plugin)this);
        EndListener.loadFromConfig();
        Sounds.setup();
        ClaimTool.setup();
        this.getServer().getPluginManager().registerEvents((Listener)new EndListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClaimTool(), (Plugin)this);
        if (config.getBoolean("spawn-elytra.enabled")) {
            this.getServer().getPluginManager().registerEvents((Listener)new SpawnBoostListener(zoneManager), (Plugin)this);
            if (config.getBoolean("spawn-elytra.disable-rockets")) {
                this.getServer().getPluginManager().registerEvents((Listener)new DisableBoostListener(), (Plugin)this);
            }
            zoneManager.loadZoneFromConfig();
        }
        if (config.getBoolean("claims.enabled")) {
            ClaimDataInstance.defaultChunksLeftAmount = config.getInt("claims.max-chunk-claim-amount", 1024);
            claimManager = new ClaimManager((Plugin)this, "claim-data.yml");
            if (config.getBoolean("claims.save-on-world-save")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ClaimDataSaveListener(claimManager), (Plugin)this);
            }
        }
        if (config.getBoolean("status.enabled")) {
            statusConfig = new StatusConfig((Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerStatus(), (Plugin)this);
        }
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            ((Commands)commands.registrar()).register(new BuildMcCommand().getCommand());
            if (config.getBoolean("status.enabled")) {
                ((Commands)commands.registrar()).register(new SetStatusCommand(statusConfig).getCommand());
            }
            if (config.getBoolean("claims.enabled")) {
                ((Commands)commands.registrar()).register(new ClaimCommand().getCommand());
            }
        });
        if (config.getBoolean("disable-commands") && config.isList("disabled-commands")) {
            for (String fullCommand : config.getStringList("disabled-commands")) {
                String[] parts = fullCommand.split(":", 2);
                if (parts.length == 2) {
                    this.disableCommand(parts[0], parts[1]);
                    continue;
                }
                logger.warning("Invalid command format in 'disabled-commands': " + fullCommand);
            }
        }
        if (config.getBoolean("player-head.on-death")) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerHeadDropDeathListener(new PlayerHeadDropModifier()), (Plugin)this);
        }
    }

    public void onDisable() {
        try {
            claimManager.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CoreMain.stop();
    }

    private void disableCommand(String namespace, String commandName) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            if (!(commandMap instanceof SimpleCommandMap)) {
                logger.warning("Unsupported CommandMap implementation. Cannot disable command: " + commandName);
                return;
            }
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            Map knownCommands = (Map)knownCommandsField.get(commandMap);
            knownCommands.keySet().removeIf(key -> key.equalsIgnoreCase(commandName) || key.equalsIgnoreCase(namespace + ":" + commandName) || key.endsWith(":" + commandName));
            Command blockedCommand = new Command(this, commandName){

                public boolean execute(@NotNull CommandSender sender, @NotNull String label, String @NotNull [] args) {
                    sender.sendMessage(Message.msg(sender, "messages.error.command-disabled"));
                    return true;
                }
            };
            commandMap.register(namespace, blockedCommand);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.warning("Failed to fully disable command '" + commandName + "': " + e.getMessage());
        }
    }

    private CommandMap getCommandMap() {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            return (CommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            logger.warning("Failed to retrieve the command map.");
            return null;
        }
    }

    @Override
    public void sendPlayerMessage(Player player, Component message) {
        player.sendMessage(message);
    }

    @Override
    public void sendPlayerActionBar(Player player, Component message) {
        player.sendActionBar(message);
    }

    static {
        zoneManager = new ElytraZoneManager();
    }
}

