/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.adventuresupport;

import com.github.stefvanschie.inventoryframework.adventuresupport.ForeignComponentHolder;
import com.github.stefvanschie.inventoryframework.adventuresupport.NativeComponentHolder;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.google.gson.JsonElement;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentHolder
extends TextHolder {
    @Nullable
    private static Boolean nativeAdventureSupport;
    @Nullable
    private static LegacyComponentSerializer legacySerializer;
    @NotNull
    protected final Component value;

    @NotNull
    @Contract(pure=true)
    public static ComponentHolder of(@NotNull Component value) {
        Validate.notNull((Object)value, (String)"value mustn't be null");
        return ComponentHolder.isNativeAdventureSupport() ? new NativeComponentHolder(value) : new ForeignComponentHolder(value);
    }

    private static boolean isNativeAdventureSupport() {
        if (nativeAdventureSupport == null) {
            try {
                TextComponent component = Component.text("test");
                NativeComponentHolder holder = new NativeComponentHolder(component);
                Inventory ignored1 = holder.asInventoryTitle(null, 9);
                Inventory ignored2 = holder.asInventoryTitle(null, InventoryType.HOPPER);
                ItemMeta meta = new ItemStack(Material.STONE).getItemMeta();
                holder.asItemDisplayName(meta);
                holder.asItemLoreAtEnd(meta);
                nativeAdventureSupport = true;
            }
            catch (Throwable t) {
                nativeAdventureSupport = false;
            }
        }
        return nativeAdventureSupport;
    }

    private static LegacyComponentSerializer getLegacySerializer() {
        if (legacySerializer == null) {
            LegacyComponentSerializer.Builder builder = LegacyComponentSerializer.builder().character('\u00a7');
            if (!ChatColor.class.isEnum()) {
                builder.hexColors().useUnusualXRepeatedCharacterHexFormat();
            }
            legacySerializer = builder.build();
        }
        return legacySerializer;
    }

    ComponentHolder(@NotNull Component value) {
        this.value = value;
    }

    @NotNull
    @Contract(pure=true)
    public Component getComponent() {
        return this.value;
    }

    @NotNull
    @Contract(pure=true)
    public JsonElement asJson() {
        return GsonComponentSerializer.gson().serializeToTree(this.value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.value + "}";
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && Objects.equals(this.value, ((ComponentHolder)other).value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public String asLegacyString() {
        return ComponentHolder.getLegacySerializer().serialize(this.value);
    }
}

