/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_16_4_5;

import com.github.stefvanschie.inventoryframework.abstraction.SmithingTableInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_16_4_5.util.TextHolderUtil;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.ContainerAccess;
import net.minecraft.server.v1_16_R3.ContainerSmithing;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IInventory;
import net.minecraft.server.v1_16_R3.ITileInventory;
import net.minecraft.server.v1_16_R3.InventoryCraftResult;
import net.minecraft.server.v1_16_R3.InventoryLargeChest;
import net.minecraft.server.v1_16_R3.InventorySubcontainer;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.PlayerInventory;
import net.minecraft.server.v1_16_R3.Slot;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventorySmithing;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmithingTableInventoryImpl
extends SmithingTableInventory {
    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory(final @NotNull TextHolder title) {
        final InventoryCraftResult resultSlot = new InventoryCraftResult();
        InventoryViewProvider container = new InventoryViewProvider(){

            @NotNull
            @Contract(pure=true)
            public Container createMenu(int containerId, @Nullable PlayerInventory inventory, @NotNull EntityHuman player) {
                return new ContainerSmithingTableImpl(containerId, player, this, resultSlot);
            }

            @NotNull
            @Contract(pure=true)
            public IChatBaseComponent getScoreboardDisplayName() {
                return TextHolderUtil.toComponent(title);
            }
        };
        return new CraftInventorySmithing(null, (IInventory)container, (IInventory)resultSlot, (IInventory)container){
            final /* synthetic */ IInventory val$container;
            {
                this.val$container = iInventory;
                super(location, inventory, resultInventory);
            }

            @NotNull
            @Contract(pure=true)
            public InventoryType getType() {
                return InventoryType.SMITHING;
            }

            public IInventory getInventory() {
                return this.val$container;
            }
        };
    }

    private static class ContainerSmithingTableImpl
    extends ContainerSmithing {
        @NotNull
        private final HumanEntity humanEntity;
        @NotNull
        private final InventorySubcontainer itemsSlots;
        @NotNull
        private final InventoryCraftResult resultSlot;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerSmithingTableImpl(int containerId, @NotNull EntityHuman player, @NotNull InventorySubcontainer itemsSlots, @NotNull InventoryCraftResult resultSlot) {
            super(containerId, player.inventory, ContainerAccess.at((World)player.getWorld(), (BlockPosition)BlockPosition.ZERO));
            this.humanEntity = player.getBukkitEntity();
            this.itemsSlots = itemsSlots;
            this.resultSlot = resultSlot;
            this.checkReachable = false;
            InventoryLargeChest container = new InventoryLargeChest((IInventory)itemsSlots, (IInventory)resultSlot);
            this.updateSlot(0, (IInventory)container);
            this.updateSlot(1, (IInventory)container);
            this.updateSlot(2, (IInventory)container);
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity != null) {
                return this.bukkitEntity;
            }
            CraftInventorySmithing inventory = new CraftInventorySmithing(this.containerAccess.getLocation(), (IInventory)this.itemsSlots, (IInventory)this.resultSlot);
            this.bukkitEntity = new CraftInventoryView(this.humanEntity, (Inventory)inventory, (Container)this);
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void b(EntityHuman nmsPlayer) {
        }

        public void e() {
        }

        protected ItemStack a(EntityHuman player, ItemStack stack) {
            return stack;
        }

        protected boolean b(EntityHuman player, boolean present) {
            return true;
        }

        private void updateSlot(int slotIndex, @NotNull IInventory container) {
            Slot slot = (Slot)this.slots.get(slotIndex);
            Slot newSlot = new Slot(container, slot.index, slot.e, slot.f);
            newSlot.rawSlotIndex = slot.rawSlotIndex;
            this.slots.set(slotIndex, newSlot);
        }
    }

    private static abstract class InventoryViewProvider
    extends InventorySubcontainer
    implements ITileInventory {
        public InventoryViewProvider() {
            super(2);
        }
    }
}

