/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.Orientable;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.util.Slot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MasonryPane
extends Pane
implements Orientable {
    @NotNull
    private final List<Pane> panes = new ArrayList<Pane>();
    @NotNull
    private Orientable.Orientation orientation = Orientable.Orientation.HORIZONTAL;

    public MasonryPane(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority) {
        super(slot, length, height, priority);
    }

    public MasonryPane(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        super(x, y, length, height, priority);
    }

    public MasonryPane(@NotNull Slot slot, int length, int height) {
        super(slot, length, height);
    }

    public MasonryPane(int x, int y, int length, int height) {
        super(x, y, length, height);
    }

    public MasonryPane(int length, int height) {
        super(length, height);
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int[][] positions;
        int length = Math.min(this.length, maxLength) - paneOffsetX;
        int height = Math.min(this.height, maxHeight) - paneOffsetY;
        for (int[] array : positions = new int[length][height]) {
            Arrays.fill(array, -1);
        }
        block1: for (int paneIndex = 0; paneIndex < this.panes.size(); ++paneIndex) {
            int j;
            int i;
            boolean fits;
            Pane pane = this.panes.get(paneIndex);
            if (!pane.isVisible()) continue;
            if (this.orientation == Orientable.Orientation.HORIZONTAL) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < length; ++x) {
                        fits = true;
                        block4: for (i = 0; i < pane.getLength(); ++i) {
                            for (j = 0; j < pane.getHeight(); ++j) {
                                if (x + i < positions.length && y + j < positions[x + i].length && positions[x + i][y + j] == -1) continue;
                                fits = false;
                                break block4;
                            }
                        }
                        if (!fits) continue;
                        for (i = 0; i < pane.getLength(); ++i) {
                            for (j = 0; j < pane.getHeight(); ++j) {
                                positions[x + i][y + j] = paneIndex;
                            }
                        }
                        pane.setX(x);
                        pane.setY(y);
                        pane.display(inventoryComponent, paneOffsetX + this.getSlot().getX(length), paneOffsetY + this.getSlot().getY(length), Math.min(this.length, maxLength), Math.min(this.height, maxHeight));
                        continue block1;
                    }
                }
                continue;
            }
            if (this.orientation != Orientable.Orientation.VERTICAL) continue;
            for (int x = 0; x < length; ++x) {
                for (int y = 0; y < height; ++y) {
                    fits = true;
                    block10: for (i = 0; i < pane.getHeight(); ++i) {
                        for (j = 0; j < pane.getLength(); ++j) {
                            if (x + j < positions.length && y + i < positions[x + j].length && positions[x + j][y + i] == -1) continue;
                            fits = false;
                            break block10;
                        }
                    }
                    if (!fits) continue;
                    for (i = 0; i < pane.getLength(); ++i) {
                        for (j = 0; j < pane.getHeight(); ++j) {
                            positions[x + i][y + j] = paneIndex;
                        }
                    }
                    pane.setX(x);
                    pane.setY(y);
                    pane.display(inventoryComponent, paneOffsetX + this.getSlot().getX(length), paneOffsetY + this.getSlot().getY(length), Math.min(this.length, maxLength), Math.min(this.height, maxHeight));
                    continue block1;
                }
            }
        }
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.callOnClick(event);
        boolean success = false;
        for (Pane pane : new ArrayList<Pane>(this.panes)) {
            if (!pane.isVisible()) continue;
            success = success || pane.click(gui, inventoryComponent, event, slot, paneOffsetX + xPosition, paneOffsetY + yPosition, length, height);
        }
        return success;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public MasonryPane copy() {
        MasonryPane masonryPane = new MasonryPane(this.getSlot(), this.length, this.height, this.getPriority());
        for (Pane pane : this.panes) {
            masonryPane.addPane(pane.copy());
        }
        masonryPane.setVisible(this.isVisible());
        masonryPane.onClick = this.onClick;
        masonryPane.orientation = this.orientation;
        masonryPane.uuid = this.uuid;
        return masonryPane;
    }

    public void addPane(@NotNull Pane pane) {
        this.panes.add(pane);
    }

    @Override
    @NotNull
    public Collection<GuiItem> getItems() {
        return this.getPanes().stream().flatMap(pane -> pane.getItems().stream()).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Collection<Pane> getPanes() {
        HashSet<Pane> panes = new HashSet<Pane>();
        this.panes.forEach(p -> {
            panes.addAll(p.getPanes());
            panes.add((Pane)p);
        });
        return panes;
    }

    @Override
    public void clear() {
        this.panes.clear();
    }

    @Override
    @NotNull
    public Orientable.Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(@NotNull Orientable.Orientation orientation) {
        this.orientation = orientation;
    }

    @NotNull
    public static MasonryPane load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        try {
            MasonryPane masonryPane = new MasonryPane(Integer.parseInt(element.getAttribute("length")), Integer.parseInt(element.getAttribute("height")));
            Pane.load(masonryPane, instance, element);
            Orientable.load(masonryPane, element);
            if (element.hasAttribute("populate")) {
                return masonryPane;
            }
            NodeList childNodes = element.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node pane = childNodes.item(j);
                if (pane.getNodeType() != 1) continue;
                masonryPane.addPane(Gui.loadPane(instance, pane, plugin));
            }
            return masonryPane;
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
    }

    @Deprecated
    @NotNull
    public static MasonryPane load(@NotNull Object instance, @NotNull Element element) {
        return MasonryPane.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(MasonryPane.class));
    }
}

