/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane.component;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.Flippable;
import com.github.stefvanschie.inventoryframework.pane.Orientable;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.component.util.VariableBar;
import com.github.stefvanschie.inventoryframework.pane.util.Slot;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class PercentageBar
extends VariableBar {
    public PercentageBar(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority, @NotNull Plugin plugin) {
        super(slot, length, height, priority, plugin);
    }

    public PercentageBar(int x, int y, int length, int height, @NotNull Pane.Priority priority, @NotNull Plugin plugin) {
        super(x, y, length, height, priority, plugin);
    }

    public PercentageBar(@NotNull Slot slot, int length, int height, @NotNull Plugin plugin) {
        super(slot, length, height, plugin);
    }

    public PercentageBar(int x, int y, int length, int height, @NotNull Plugin plugin) {
        super(x, y, length, height, plugin);
    }

    public PercentageBar(int length, int height, @NotNull Plugin plugin) {
        super(length, height, plugin);
    }

    public PercentageBar(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority) {
        super(slot, length, height, priority);
    }

    public PercentageBar(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        super(x, y, length, height, priority);
    }

    public PercentageBar(@NotNull Slot slot, int length, int height) {
        super(slot, length, height);
    }

    public PercentageBar(int x, int y, int length, int height) {
        super(x, y, length, height);
    }

    public PercentageBar(int length, int height) {
        super(length, height);
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.callOnClick(event);
        event.setCancelled(true);
        int newPaneOffsetX = paneOffsetX + xPosition;
        int newPaneOffsetY = paneOffsetY + yPosition;
        return this.fillPane.click(gui, inventoryComponent, event, slot, newPaneOffsetX, newPaneOffsetY, length, height) || this.backgroundPane.click(gui, inventoryComponent, event, slot, newPaneOffsetX, newPaneOffsetY, length, height);
    }

    public void setPercentage(float percentage) {
        super.setValue(percentage);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public PercentageBar copy() {
        PercentageBar percentageBar = new PercentageBar(this.getSlot(), this.length, this.height, this.getPriority());
        this.applyContents(percentageBar);
        return percentageBar;
    }

    public float getPercentage() {
        return this.value;
    }

    @NotNull
    @Contract(pure=true)
    public static PercentageBar load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        int height;
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
            height = Integer.parseInt(element.getAttribute("height"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        PercentageBar percentageBar = new PercentageBar(length, height, plugin);
        Pane.load(percentageBar, instance, element);
        Orientable.load(percentageBar, element);
        Flippable.load(percentageBar, element);
        if (element.hasAttribute("populate")) {
            return percentageBar;
        }
        if (element.hasAttribute("percentage")) {
            try {
                percentageBar.setPercentage(Float.parseFloat(element.getAttribute("percentage")));
            }
            catch (IllegalArgumentException exception) {
                throw new XMLLoadException(exception);
            }
        }
        return percentageBar;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static PercentageBar load(@NotNull Object instance, @NotNull Element element) {
        return PercentageBar.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(PercentageBar.class));
    }
}

