/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.MainClass;
import net.mathias2246.buildmc.PluginMain;
import net.mathias2246.buildmc.api.claims.ClaimManager;
import net.mathias2246.buildmc.api.endEvent.EndManager;
import net.mathias2246.buildmc.api.item.CustomItemListener;
import net.mathias2246.buildmc.api.item.CustomItemRegistry;
import net.mathias2246.buildmc.api.spawnEyltra.ElytraManager;
import net.mathias2246.buildmc.api.spawnelytra.ElytraManagerImpl;
import net.mathias2246.buildmc.claims.ClaimCommand;
import net.mathias2246.buildmc.claims.ClaimManagerImpl;
import net.mathias2246.buildmc.claims.ClaimToolParticles;
import net.mathias2246.buildmc.claims.tools.ClaimSelectionTool;
import net.mathias2246.buildmc.commands.BuildMcCommand;
import net.mathias2246.buildmc.endEvent.EndListener;
import net.mathias2246.buildmc.endEvent.EndManagerImpl;
import net.mathias2246.buildmc.platform.SoundManagerPaperImpl;
import net.mathias2246.buildmc.player.PlayerHeadDropDeathListener;
import net.mathias2246.buildmc.player.PlayerHeadDropModifier;
import net.mathias2246.buildmc.player.PlayerSpawnTeleportCommand;
import net.mathias2246.buildmc.spawnElytra.DisableBoostListener;
import net.mathias2246.buildmc.spawnElytra.ElytraListeners;
import net.mathias2246.buildmc.spawnElytra.ElytraZoneManager;
import net.mathias2246.buildmc.status.PlayerStatus;
import net.mathias2246.buildmc.status.SetStatusCommand;
import net.mathias2246.buildmc.status.StatusConfig;
import net.mathias2246.buildmc.util.Message;
import net.mathias2246.buildmc.util.RegistriesHolder;
import net.mathias2246.buildmc.util.SoundManager;
import net.mathias2246.buildmc.util.config.ConfigurationValidationException;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public final class Main
extends PluginMain {
    public static Logger logger;
    public static Plugin plugin;
    @Subst(value="")
    public static FileConfiguration config;
    public static File configFile;
    public static File pluginFolder;
    public static final ElytraZoneManager zoneManager;
    public static StatusConfig statusConfig;
    public static CustomItemRegistry customItems;
    public static ClaimManager apiClaimManager;
    public static EndManager apiEndManager;
    private static ElytraManager apiElytraManager;

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        pluginFolder = plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdir();
        }
        if (!(configFile = new File(plugin.getDataFolder(), "config.yml")).exists()) {
            this.saveResource("config.yml", false);
        }
        config = this.getConfig();
        CoreMain.initialize(this);
        customItems = new CustomItemRegistry();
        if (config.getBoolean("claims.enabled", true)) {
            customItems.register(new ClaimSelectionTool((Plugin)this, Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:claim_tool")), new ClaimToolParticles.Builder()));
        }
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            ((Commands)commands.registrar()).register(new BuildMcCommand().getCommand());
            ((Commands)commands.registrar()).register(new SetStatusCommand(statusConfig).getCommand());
            ((Commands)commands.registrar()).register(new ClaimCommand().getCommand());
            ((Commands)commands.registrar()).register(new PlayerSpawnTeleportCommand().getCommand());
        });
        try {
            EndListener.loadFromConfig();
        }
        catch (ConfigurationValidationException e) {
            throw new RuntimeException(e);
        }
        SoundManagerPaperImpl.setup();
        CoreMain.soundManager = new SoundManagerPaperImpl();
        apiClaimManager = new ClaimManagerImpl();
        apiEndManager = new EndManagerImpl();
        apiElytraManager = new ElytraManagerImpl(zoneManager);
    }

    public void onDisable() {
        CoreMain.stop();
    }

    private void registerEvent(@NotNull Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private void disableCommand(String namespace, String commandName) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            if (!(commandMap instanceof SimpleCommandMap)) {
                logger.warning("Unsupported CommandMap implementation. Cannot disable command: " + commandName);
                return;
            }
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            Map knownCommands = (Map)knownCommandsField.get(commandMap);
            knownCommands.keySet().removeIf(key -> key.equalsIgnoreCase(commandName) || key.equalsIgnoreCase(namespace + ":" + commandName) || key.endsWith(":" + commandName));
            Command blockedCommand = new Command(this, commandName){

                public boolean execute(@NotNull CommandSender sender, @NotNull String label, String @NotNull [] args) {
                    sender.sendMessage(Message.msg(sender, "messages.error.command-disabled"));
                    return true;
                }
            };
            commandMap.register(namespace, blockedCommand);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.warning("Failed to fully disable command '" + commandName + "': " + e.getMessage());
        }
    }

    private CommandMap getCommandMap() {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            return (CommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            logger.warning("Failed to retrieve the command map.");
            return null;
        }
    }

    @Override
    public void sendPlayerMessage(Player player, Component message) {
        player.sendMessage(message);
    }

    @Override
    public void sendPlayerActionBar(Player player, Component message) {
        player.sendActionBar(message);
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this;
    }

    @Override
    @NotNull
    public MainClass getMainClass() {
        return this;
    }

    @Override
    @NotNull
    public SoundManager getSoundManager() {
        return CoreMain.soundManager;
    }

    @Override
    public ClaimManager getClaimManager() {
        return apiClaimManager;
    }

    @Override
    public EndManager getEndManager() {
        return apiEndManager;
    }

    @Override
    public ElytraManager getElytraManager() {
        return apiElytraManager;
    }

    @Override
    @NotNull
    public RegistriesHolder getRegistriesHolder() {
        return CoreMain.registriesHolder;
    }

    @Override
    public void editConfiguration(@NotNull Consumer<FileConfiguration> consumer) {
        consumer.accept(config);
    }

    @Override
    public void finishLoading() {
        this.getServer().getPluginManager().registerEvents((Listener)new CustomItemListener(customItems), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EndListener(), (Plugin)this);
        if (config.getBoolean("spawn-elytra.enabled")) {
            this.getServer().getPluginManager().registerEvents((Listener)new ElytraListeners(config.getBoolean("spawn-elytra.enabled", true), config.getDouble("spawn-elytra.strength", 2.0)), (Plugin)this);
            if (config.getBoolean("spawn-elytra.disable-rockets")) {
                this.getServer().getPluginManager().registerEvents((Listener)new DisableBoostListener(), (Plugin)this);
            }
            zoneManager.loadZoneFromConfig();
        }
        if (config.getBoolean("status.enabled")) {
            statusConfig = new StatusConfig((Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerStatus(), (Plugin)this);
        }
        if (config.getBoolean("disable-commands") && config.isList("disabled-commands")) {
            for (String fullCommand : config.getStringList("disabled-commands")) {
                String[] parts = fullCommand.split(":", 2);
                if (parts.length == 2) {
                    this.disableCommand(parts[0], parts[1]);
                    continue;
                }
                logger.warning("Invalid command format in 'disabled-commands': " + fullCommand);
            }
        }
        if (config.getBoolean("player-head.on-death")) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerHeadDropDeathListener(new PlayerHeadDropModifier()), (Plugin)this);
        }
    }

    static {
        zoneManager = new ElytraZoneManager();
    }
}

