/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.event.claims.ClaimProtectionChangeEvent;
import net.mathias2246.buildmc.claims.ClaimLogger;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.claims.ClaimToolItemMetaModifier;
import net.mathias2246.buildmc.claims.claimSubCommands.CreateClaimSubCommand;
import net.mathias2246.buildmc.claims.claimSubCommands.WhitelistSubCommand;
import net.mathias2246.buildmc.claims.tools.ClaimSelectionTool;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.ui.claims.ClaimSelectMenu;
import net.mathias2246.buildmc.util.CommandUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public class ClaimCommand
implements CustomCommand {
    @NotNull
    private static final ClaimToolItemMetaModifier claimToolNameAndTooltip = new ClaimToolItemMetaModifier();
    private static ClaimSelectionTool claimTool;

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        LiteralArgumentBuilder cmd = Commands.literal((String)"claim");
        cmd.requires(command -> {
            boolean t = Main.config.getBoolean("claims.enabled", true);
            claimTool = !t ? null : (ClaimSelectionTool)Main.customItems.get(Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:claim_tool")).key());
            return t;
        });
        cmd.executes(ClaimCommand::handleEdit);
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"claimtool").requires(command -> Main.config.getBoolean("claims.tool.enable-give-command", true))).executes(ClaimCommand::handleGetClaimTool));
        cmd.then(Commands.literal((String)"edit").executes(ClaimCommand::handleEdit));
        cmd.then(Commands.literal((String)"who").executes(ClaimCommand::handleWho));
        cmd.then(Commands.literal((String)"help").executes(ClaimCommand::handleHelp));
        cmd.then(CreateClaimSubCommand.createSubCommand());
        cmd.then(Commands.literal((String)"remove").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(ClaimCommand::claimTypesSuggestions).then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.word()).suggests(ClaimCommand::claimIdsSuggestions).executes(command -> {
            CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
            Player patt0$temp = CommandUtil.requiresPlayer((CommandContext<CommandSourceStack>)command);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = StringArgumentType.getString((CommandContext)command, (String)"type").toLowerCase();
            String claimName = StringArgumentType.getString((CommandContext)command, (String)"claim");
            long claimId = -1L;
            block6 : switch (type) {
                case "player": {
                    List ids = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                    Iterator iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        String name = ClaimManager.getClaimNameById(id);
                        if (name == null || !name.equalsIgnoreCase(claimName)) continue;
                        claimId = id;
                        break block6;
                    }
                    break;
                }
                case "team": {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        player.sendMessage((Component)Component.translatable("messages.error.not-in-a-team"));
                        return 0;
                    }
                    List ids = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                    Iterator id = ids.iterator();
                    while (id.hasNext()) {
                        long id2 = (Long)id.next();
                        String name = ClaimManager.getClaimNameById(id2);
                        if (name == null || !name.equalsIgnoreCase(claimName)) continue;
                        claimId = id2;
                        break block6;
                    }
                    break;
                }
                case "server": 
                case "placeholder": {
                    if (!player.hasPermission("buildmc.admin")) {
                        player.sendMessage((Component)Component.translatable("messages.error.no-permission"));
                        return 0;
                    }
                    List<Long> ids = type.equals("server") ? ClaimManager.serverClaims : ClaimManager.placeholderClaims;
                    for (long id : ids) {
                        String name = ClaimManager.getClaimNameById(id);
                        if (name == null || !name.equalsIgnoreCase(claimName)) continue;
                        claimId = id;
                        break block6;
                    }
                    break;
                }
                default: {
                    player.sendMessage((Component)Component.translatable("messages.claims.remove.invalid-type"));
                    return 0;
                }
            }
            if (claimId == -1L) {
                player.sendMessage((Component)Component.translatable("messages.claims.remove.not-found"));
                return 0;
            }
            boolean success = ClaimManager.removeClaimById(claimId);
            if (success) {
                player.sendMessage((Component)Component.translatable("messages.claims.remove.success"));
                ClaimLogger.logClaimDeleted(player, claimName);
            } else {
                player.sendMessage((Component)Component.translatable("messages.claims.remove.failed"));
            }
            return success ? 1 : 0;
        }))));
        cmd.then(WhitelistSubCommand.createSubCommand());
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"protections").requires(command -> !CoreMain.plugin.getConfig().getBoolean("claims.hide-all-protections"))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(ClaimCommand::claimTypesSuggestions).then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.word()).suggests(ClaimCommand::claimIdsSuggestions).then(Commands.argument((String)"key", (ArgumentType)ArgumentTypes.namespacedKey()).suggests((ctx, builder) -> {
            String remaining = builder.getRemaining();
            Iterator<Protection> iterator = CoreMain.protectionsRegistry.iterator();
            while (iterator.hasNext()) {
                Protection flag = iterator.next();
                String s = flag.getKey().toString();
                if (flag.isHidden() || !s.startsWith(remaining.toLowerCase())) continue;
                builder.suggest(s);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.word()).suggests(CommandUtil::booleanSuggestion).executes(command -> {
            boolean value;
            CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
            Player patt0$temp = CommandUtil.requiresPlayer((CommandContext<CommandSourceStack>)command);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = StringArgumentType.getString((CommandContext)command, (String)"type").toLowerCase();
            String claimName = StringArgumentType.getString((CommandContext)command, (String)"claim");
            NamespacedKey flag = (NamespacedKey)command.getArgument("key", NamespacedKey.class);
            String valueStr = StringArgumentType.getString((CommandContext)command, (String)"value").toLowerCase();
            if (valueStr.equals("true")) {
                value = true;
            } else if (valueStr.equals("false")) {
                value = false;
            } else {
                player.sendMessage((Component)Component.translatable("messages.claims.protections.invalid-value"));
                return 0;
            }
            if (flag == null || Protection.isHiddenProtection(CoreMain.protectionsRegistry, flag)) {
                player.sendMessage((Component)Component.translatable("messages.claims.protections.invalid-flag"));
                return 0;
            }
            Claim claim = null;
            long claimId = -1L;
            block5 : switch (type) {
                case "player": {
                    List ids = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                    Iterator iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        if (!claimName.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                        claim = ClaimManager.getClaimByID(id);
                        claimId = id;
                        break block5;
                    }
                    break;
                }
                case "team": {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        player.sendMessage((Component)Component.translatable("messages.error.not-in-a-team"));
                        return 0;
                    }
                    List ids = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                    Iterator iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        if (!claimName.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                        claim = ClaimManager.getClaimByID(id);
                        claimId = id;
                        break block5;
                    }
                    break;
                }
                case "server": {
                    if (!player.hasPermission("buildmc.admin")) {
                        player.sendMessage((Component)Component.translatable("messages.error.no-permission"));
                        return 0;
                    }
                    for (long id : ClaimManager.serverClaims) {
                        if (!claimName.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                        claim = ClaimManager.getClaimByID(id);
                        claimId = id;
                        break block5;
                    }
                    break;
                }
                default: {
                    player.sendMessage((Component)Component.translatable("messages.claims.protections.invalid-type"));
                    return 0;
                }
            }
            if (claim == null || claimId == -1L) {
                player.sendMessage((Component)Component.translatable("messages.claims.remove.not-found"));
                return 0;
            }
            Protection protection = CoreMain.protectionLookup.get(flag);
            if (value) {
                ClaimProtectionChangeEvent event = new ClaimProtectionChangeEvent(claim, protection, ClaimProtectionChangeEvent.ActiveState.ENABLED, sender);
                if (event.isCancelled()) {
                    return 0;
                }
                ClaimManager.addProtection(claimId, flag);
                player.sendMessage(Message.msg(player, "messages.claims.protections.added", Map.of("flag", flag.toString())));
                ClaimLogger.logProtectionChanged(player, claimName, flag.toString(), "enabled");
            } else {
                ClaimProtectionChangeEvent event = new ClaimProtectionChangeEvent(claim, protection, ClaimProtectionChangeEvent.ActiveState.DISABLED, sender);
                if (event.isCancelled()) {
                    return 0;
                }
                ClaimManager.removeProtection(claimId, flag);
                player.sendMessage(Message.msg(player, "messages.claims.protections.removed", Map.of("flag", flag.toString())));
                ClaimLogger.logProtectionChanged(player, claimName, flag.toString(), "disabled");
            }
            return 1;
        }))))));
        return cmd.build();
    }

    protected static int handleEdit(CommandContext<CommandSourceStack> command) {
        Player player = CommandUtil.requiresPlayer(command);
        if (!(player instanceof Player)) {
            return 0;
        }
        Player player2 = player;
        ClaimSelectMenu.open(player2);
        return 1;
    }

    protected static int handleGetClaimTool(CommandContext<CommandSourceStack> command) {
        Player player = CommandUtil.requiresPlayer(command);
        if (!(player instanceof Player)) {
            return 0;
        }
        Player player2 = player;
        if (player2.getInventory().firstEmpty() == -1) {
            player2.sendMessage((Component)Component.translatable("messages.claims.tool.full-inventory"));
            return 0;
        }
        claimTool.giveToPlayer(player2, claimToolNameAndTooltip);
        player2.sendMessage((Component)Component.translatable("messages.claims.tool.give-success"));
        return 1;
    }

    protected static int handleWho(CommandContext<CommandSourceStack> command) {
        Claim claim;
        Player player = CommandUtil.requiresPlayer(command);
        if (!(player instanceof Player)) {
            return 0;
        }
        Player player2 = player;
        try {
            claim = ClaimManager.getClaim(player2.getLocation());
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("An error occurred while getting a claim from the database: " + e.getMessage());
            player2.sendMessage((Component)Component.translatable("messages.error.sql"));
            return 0;
        }
        if (claim == null) {
            ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.claims.who.unclaimed"));
            return 1;
        }
        ClaimType claimType = claim.getType();
        if (claimType == ClaimType.TEAM) {
            player2.sendMessage(Message.msg(player2, "messages.claims.who.team-message", Map.of("owner", claim.getOwnerId())));
        } else if (claimType == ClaimType.PLAYER) {
            UUID ownerId = UUID.fromString(claim.getOwnerId());
            OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)ownerId);
            String ownerName = owner.getName();
            if (ownerName == null) {
                ownerName = "Unknown";
            }
            player2.sendMessage(Message.msg(player2, "messages.claims.who.player-message", Map.of("owner", ownerName)));
        } else if (claimType == ClaimType.SERVER || claimType == ClaimType.PLACEHOLDER) {
            player2.sendMessage(Message.msg(player2, "messages.claims.who.server-message"));
        }
        return 1;
    }

    protected static int handleHelp(CommandContext<CommandSourceStack> command) {
        CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
        sender.sendMessage((Component)Component.translatable("messages.claims.help-message"));
        return 1;
    }

    public static CompletableFuture<Suggestions> claimTypesSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Player player;
        ArrayList<String> suggestions = new ArrayList<String>(List.of("player", "team"));
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (commandSender instanceof Player && (player = (Player)commandSender).hasPermission("buildmc.admin")) {
            suggestions.add("server");
            suggestions.add("placeholder");
        }
        for (String suggestion : suggestions) {
            if (!suggestion.startsWith(builder.getRemaining().toLowerCase())) continue;
            builder.suggest(suggestion);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> claimIdsSuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        block6: {
            String type;
            Player player;
            block7: {
                block5: {
                    CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
                    if (!(sender instanceof Player)) {
                        return builder.buildFuture();
                    }
                    player = (Player)sender;
                    type = StringArgumentType.getString(ctx, (String)"type");
                    if (!type.equalsIgnoreCase("player")) break block5;
                    List claimIds = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                    Iterator iterator = claimIds.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        String name = ClaimManager.getClaimNameById(id);
                        if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                        builder.suggest(name);
                    }
                    break block6;
                }
                if (!type.equalsIgnoreCase("team")) break block7;
                Team team = ClaimManager.getPlayerTeam(player);
                if (team == null) break block6;
                List claimIds = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                Iterator id = claimIds.iterator();
                while (id.hasNext()) {
                    long id2 = (Long)id.next();
                    String name = ClaimManager.getClaimNameById(id2);
                    if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
                break block6;
            }
            if (type.equalsIgnoreCase("server") && player.hasPermission("buildmc.admin")) {
                List<Long> claimIds = ClaimManager.serverClaims;
                for (long id : claimIds) {
                    String name = ClaimManager.getClaimNameById(id);
                    if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
            }
        }
        return builder.buildFuture();
    }
}

