/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.claimSubCommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.claims.ClaimCommand;
import net.mathias2246.buildmc.claims.ClaimLogger;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.util.CommandUtil;
import net.mathias2246.buildmc.util.LocationUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class CreateClaimSubCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> createSubCommand() {
        return Commands.literal((String)"create").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(ClaimCommand::claimTypesSuggestions).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(command -> {
            List<Claim> overlappingClaims;
            Player patt0$temp = CommandUtil.requiresPlayer((CommandContext<CommandSourceStack>)command);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = (String)command.getArgument("type", String.class);
            String name = (String)command.getArgument("name", String.class);
            if (!player.hasMetadata("buildmc:claim_tool_first_selection") || !player.hasMetadata("buildmc:claim_tool_second_selection")) {
                player.sendMessage((Component)Component.translatable("messages.claims.create.missing-positions"));
                return 0;
            }
            Location pos1 = LocationUtil.tryDeserialize(((MetadataValue)player.getMetadata("buildmc:claim_tool_first_selection").getFirst()).asString());
            Location pos2 = LocationUtil.tryDeserialize(((MetadataValue)player.getMetadata("buildmc:claim_tool_second_selection").getFirst()).asString());
            if (pos1 == null || pos2 == null) {
                player.sendMessage((Component)Component.translatable("messages.claims.create.missing-positions"));
                return 0;
            }
            if (!pos1.getWorld().equals((Object)pos2.getWorld())) {
                player.sendMessage((Component)Component.translatable("messages.claims.create.different-worlds"));
                return 0;
            }
            try {
                overlappingClaims = ClaimManager.getClaimsInArea(pos1, pos2);
            }
            catch (SQLException e) {
                CoreMain.plugin.getLogger().severe("There was an error while getting the claims in an area: " + e.getMessage());
                player.sendMessage((Component)Component.translatable("messages.claims.create.error-database"));
                return 0;
            }
            if (!overlappingClaims.isEmpty()) {
                boolean serverProtected = overlappingClaims.stream().anyMatch(claim -> claim.getType() == ClaimType.SERVER);
                if (serverProtected) {
                    player.sendMessage((Component)Component.translatable("messages.claims.create.protected-server"));
                } else {
                    player.sendMessage((Component)Component.translatable("messages.claims.create.overlap"));
                }
                return 0;
            }
            int newClaimChunks = LocationUtil.calculateChunkArea(pos1, pos2);
            switch (type.toLowerCase()) {
                case "player": {
                    int maxChunksAllowed = CoreMain.plugin.getConfig().getInt("claims.player-max-chunk-claim-amount");
                    int remainingChunks = ClaimManager.playerRemainingClaims.getOrDefault(player.getUniqueId().toString(), maxChunksAllowed);
                    if (remainingChunks - newClaimChunks < 0) {
                        player.sendMessage(Message.msg(player, "messages.claims.create.no-remaining-claims", Map.of("no-remaining-claims", String.valueOf(remainingChunks))));
                        return 0;
                    }
                    try {
                        if (ClaimManager.doesOwnerHaveClaimWithName(player.getUniqueId().toString(), name)) {
                            player.sendMessage((Component)Component.translatable("messages.claims.create.duplicate-name"));
                            return 1;
                        }
                    }
                    catch (SQLException e) {
                        CoreMain.plugin.getLogger().severe("SQL Error while trying to check claim name availability: " + String.valueOf(e));
                        player.sendMessage((Component)Component.translatable("messages.claims.create.error-database"));
                        return 0;
                    }
                    boolean success = ClaimManager.tryClaimPlayerArea(player, name, pos1, pos2);
                    if (success) {
                        player.sendMessage(Message.msg(player, "messages.claims.create.success", Map.of("remaining_claims", String.valueOf(remainingChunks - newClaimChunks))));
                        CreateClaimSubCommand.removeSelectionData(player);
                        ClaimLogger.logClaimCreated(player, name);
                        return 1;
                    }
                    player.sendMessage((Component)Component.translatable("messages.claims.create.failed"));
                    return 0;
                }
                case "team": {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        player.sendMessage((Component)Component.translatable("messages.error.not-in-a-team"));
                        return 0;
                    }
                    int maxChunksAllowed = CoreMain.plugin.getConfig().getInt("claims.team-max-chunk-claim-amount");
                    int remainingChunks = ClaimManager.teamRemainingClaims.getOrDefault(team.getName(), maxChunksAllowed);
                    if (remainingChunks - newClaimChunks < 0) {
                        player.sendMessage(Message.msg(player, "messages.claims.create.no-remaining-claims", Map.of("remaining_claims", String.valueOf(remainingChunks))));
                        return 0;
                    }
                    try {
                        if (ClaimManager.doesOwnerHaveClaimWithName(team.getName(), name)) {
                            player.sendMessage((Component)Component.translatable("messages.claims.create.duplicate-name"));
                            return 1;
                        }
                    }
                    catch (SQLException e) {
                        CoreMain.plugin.getLogger().severe("SQL Error while trying to check claim name availability: " + String.valueOf(e));
                        player.sendMessage((Component)Component.translatable("messages.claims.create.error-database"));
                        return 0;
                    }
                    boolean success = ClaimManager.tryClaimTeamArea(team, name, pos1, pos2);
                    if (success) {
                        player.sendMessage(Message.msg(player, "messages.claims.create.success", Map.of("remaining_claims", String.valueOf(remainingChunks - newClaimChunks))));
                        CreateClaimSubCommand.removeSelectionData(player);
                        ClaimLogger.logClaimCreated(player, name);
                        return 1;
                    }
                    player.sendMessage((Component)Component.translatable("messages.claims.create.failed"));
                    return 0;
                }
                case "server": 
                case "placeholder": {
                    boolean success;
                    if (!player.hasPermission("buildmc.admin")) {
                        player.sendMessage((Component)Component.translatable("messages.error.no-permission"));
                        return 0;
                    }
                    try {
                        if (ClaimManager.doesOwnerHaveClaimWithName(type.toLowerCase(), name)) {
                            player.sendMessage((Component)Component.translatable("messages.claims.create.duplicate-name"));
                            return 1;
                        }
                    }
                    catch (SQLException e) {
                        CoreMain.plugin.getLogger().severe("SQL Error while trying to check claim name availability: " + String.valueOf(e));
                        player.sendMessage((Component)Component.translatable("messages.claims.create.error-database"));
                        return 0;
                    }
                    switch (type.toLowerCase()) {
                        case "server": {
                            boolean bl = ClaimManager.tryClaimServerArea(name, pos1, pos2);
                            break;
                        }
                        case "placeholder": {
                            boolean bl = ClaimManager.tryClaimPlaceholderArea(name, pos1, pos2);
                            break;
                        }
                        default: {
                            boolean bl = success = false;
                        }
                    }
                    if (success) {
                        player.sendMessage(Message.msg(player, "messages.claims.create.success-" + type.toLowerCase(), Map.of("claim_name", name)));
                        CreateClaimSubCommand.removeSelectionData(player);
                        ClaimLogger.logClaimCreated(player, name);
                        return 1;
                    }
                    player.sendMessage((Component)Component.translatable("messages.claims.create.failed"));
                    return 0;
                }
            }
            player.sendMessage((Component)Component.translatable("messages.claims.create.invalid-type"));
            return 0;
        })));
    }

    private static void removeSelectionData(Player player) {
        player.removeMetadata("buildmc:claim_tool_first_selection", CoreMain.plugin);
        player.removeMetadata("buildmc:claim_tool_second_selection", CoreMain.plugin);
    }
}

