/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.claimSubCommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.api.event.claims.ClaimWhitelistChangeEvent;
import net.mathias2246.buildmc.claims.ClaimLogger;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.util.CommandUtil;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Team;

public class WhitelistSubCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> createSubCommand() {
        return Commands.literal((String)"whitelist").then(Commands.argument((String)"action", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            List<String> actions = List.of("add", "remove");
            for (String action : actions) {
                if (!action.startsWith(builder.getRemaining())) continue;
                builder.suggest(action);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Player player;
            ArrayList<String> suggestions = new ArrayList<String>(List.of("player", "team"));
            CommandSender patt0$temp = ((CommandSourceStack)ctx.getSource()).getSender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                suggestions.add("server");
            }
            for (String suggestion : suggestions) {
                if (!suggestion.startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(suggestion);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            if (!(sender instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)sender;
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            List<Object> claimIds = List.of();
            if (type.equalsIgnoreCase("player")) {
                claimIds = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
            } else if (type.equalsIgnoreCase("team")) {
                Team team = ClaimManager.getPlayerTeam(player);
                if (team != null) {
                    claimIds = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
            } else if (type.equalsIgnoreCase("server") && player.hasPermission("buildmc.admin")) {
                claimIds = ClaimManager.serverClaims;
            }
            Iterator iterator = claimIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                String name = ClaimManager.getClaimNameById(id);
                if (name == null || !name.startsWith(builder.getRemaining())) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Object team;
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            if (!(sender instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)sender;
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            String claimName = StringArgumentType.getString((CommandContext)ctx, (String)"claim");
            Claim claim = null;
            List<Object> claimIds = List.of();
            if (type.equalsIgnoreCase("player")) {
                claimIds = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
            } else if (type.equalsIgnoreCase("team")) {
                team = ClaimManager.getPlayerTeam(player);
                if (team != null) {
                    claimIds = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
            } else if (type.equalsIgnoreCase("server") && player.hasPermission("buildmc.admin")) {
                claimIds = ClaimManager.serverClaims;
            }
            team = claimIds.iterator();
            while (team.hasNext()) {
                long id = (Long)team.next();
                if (!claimName.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                claim = ClaimManager.getClaimByID(id);
                break;
            }
            if (claim == null) {
                return builder.buildFuture();
            }
            List<UUID> whitelist = claim.getWhitelistedPlayers();
            boolean isServer = claim.getType() == ClaimType.SERVER;
            for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                Team team2;
                if (offlinePlayer.getName() == null || !isServer && offlinePlayer.getUniqueId().equals(player.getUniqueId()) || whitelist.contains(offlinePlayer.getUniqueId()) || type.equalsIgnoreCase("team") && (team2 = ClaimManager.getPlayerTeam(player)) != null && team2.hasEntry(offlinePlayer.getName()) || !offlinePlayer.getName().startsWith(builder.getRemaining())) continue;
                builder.suggest(offlinePlayer.getName());
            }
            return builder.buildFuture();
        }).executes(command -> {
            CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
            Player patt0$temp = CommandUtil.requiresPlayer((CommandContext<CommandSourceStack>)command);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String action = StringArgumentType.getString((CommandContext)command, (String)"action").toLowerCase();
            String type = StringArgumentType.getString((CommandContext)command, (String)"type").toLowerCase();
            String claimName = StringArgumentType.getString((CommandContext)command, (String)"claim");
            String targetPlayerName = StringArgumentType.getString((CommandContext)command, (String)"player");
            long claimId = -1L;
            Claim claim = null;
            block5 : switch (type) {
                case "player": {
                    long id;
                    List<Long> ids = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                    Object object = ids.iterator();
                    while (object.hasNext()) {
                        id = object.next();
                        if (!claimName.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                        claim = ClaimManager.getClaimByID(id);
                        claimId = id;
                        break block5;
                    }
                    break;
                }
                case "team": {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        player.sendMessage((Component)Component.translatable("messages.error.not-in-a-team"));
                        return 0;
                    }
                    List ids = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                    Iterator id = ids.iterator();
                    while (id.hasNext()) {
                        long id2 = (Long)id.next();
                        if (!claimName.equalsIgnoreCase(ClaimManager.getClaimNameById(id2))) continue;
                        claim = ClaimManager.getClaimByID(id2);
                        claimId = id2;
                        break block5;
                    }
                    break;
                }
                case "server": {
                    long id;
                    if (!player.hasPermission("buildmc.admin")) {
                        player.sendMessage((Component)Component.translatable("messages.claims.create.invalid-type"));
                        return 0;
                    }
                    List<Long> ids = ClaimManager.serverClaims;
                    Object object = ids.iterator();
                    while (object.hasNext()) {
                        id = object.next();
                        if (!claimName.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                        claim = ClaimManager.getClaimByID(id);
                        claimId = id;
                        break block5;
                    }
                    break;
                }
                default: {
                    player.sendMessage((Component)Component.translatable("messages.claims.create.invalid-type"));
                    return 0;
                }
            }
            if (claim == null || claimId == -1L) {
                player.sendMessage((Component)Component.translatable("messages.claims.remove.not-found"));
                return 0;
            }
            Player target = Bukkit.getPlayerExact((String)targetPlayerName);
            if (target == null) {
                player.sendMessage((Component)Component.translatable("messages.claims.whitelist.player-not-found"));
                return 0;
            }
            UUID targetUUID = target.getUniqueId();
            List<UUID> whitelist = claim.getWhitelistedPlayers();
            switch (action) {
                case "add": {
                    if (whitelist.contains(targetUUID)) {
                        player.sendMessage((Component)Component.translatable("messages.claims.whitelist.already"));
                        break;
                    }
                    ClaimWhitelistChangeEvent event = new ClaimWhitelistChangeEvent(claim, (OfflinePlayer)target, sender, ClaimWhitelistChangeEvent.ChangeAction.ADDED);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return 0;
                    }
                    ClaimManager.addPlayerToWhitelist(claimId, targetUUID);
                    player.sendMessage((Component)Component.translatable("messages.claims.whitelist.added"));
                    ClaimLogger.logWhitelistAdded(player, claimName, targetPlayerName, targetUUID.toString());
                    break;
                }
                case "remove": {
                    if (!whitelist.contains(targetUUID)) {
                        player.sendMessage((Component)Component.translatable("messages.claims.whitelist.player-not-found"));
                        break;
                    }
                    ClaimWhitelistChangeEvent event = new ClaimWhitelistChangeEvent(claim, (OfflinePlayer)target, sender, ClaimWhitelistChangeEvent.ChangeAction.REMOVED);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return 0;
                    }
                    ClaimManager.removePlayerFromWhitelist(claimId, targetUUID);
                    player.sendMessage((Component)Component.translatable("messages.claims.whitelist.removed"));
                    ClaimLogger.logWhitelistRemoved(player, claimName, targetPlayerName, targetUUID.toString());
                    break;
                }
                default: {
                    player.sendMessage((Component)Component.translatable("messages.claims.whitelist.invalid-action"));
                    return 0;
                }
            }
            return 1;
        })))));
    }
}

