/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.protections.misc;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.item.ItemUtil;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.type.util.Gui;
import net.mathias2246.buildmc.ui.UIUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PistonMovement
extends Protection {
    public PistonMovement(@Nullable ConfigurationSection section) {
        super(Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:piston_movement")), section != null ? section.getBoolean("default", true) : true, section != null && section.getBoolean("is-hidden", false));
    }

    @Override
    public String getTranslationBaseKey() {
        return "claims.flags.piston-movement-across-claim-borders";
    }

    @Override
    @NotNull
    public GuiItem getDisplay(@NotNull Player uiHolder, @NotNull Gui gui) {
        String t = this.getTranslationBaseKey();
        ItemStack displayBase = new ItemStack(Material.PISTON);
        ItemUtil.editMeta(displayBase, meta -> {
            meta.setItemName(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".name")));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setLore(List.of(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".lore")).split("\n")));
        });
        return new GuiItem(displayBase, UIUtil.noInteract);
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        try {
            Block piston = event.getBlock();
            Claim pistonClaim = ClaimManager.getClaim(piston.getChunk());
            BlockFace direction = event.getDirection();
            List movedBlocks = event.getBlocks();
            for (Block movedBlock : movedBlocks) {
                Block destinationBlock = movedBlock.getRelative(direction);
                Claim fromClaim = ClaimManager.getClaim(movedBlock.getChunk());
                Claim toClaim = ClaimManager.getClaim(destinationBlock.getChunk());
                if (pistonClaim != null && toClaim == null || this.isPistonMoveAllowed(pistonClaim, fromClaim, toClaim)) continue;
                event.setCancelled(true);
                return;
            }
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("An SQLException occurred in ClaimPistonMovementListener in onPistonExtend: " + String.valueOf(e));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (!event.isSticky()) {
            return;
        }
        try {
            Block piston = event.getBlock();
            Claim pistonClaim = ClaimManager.getClaim(piston.getChunk());
            BlockFace direction = event.getDirection();
            List movedBlocks = event.getBlocks();
            for (Block movedBlock : movedBlocks) {
                Block destinationBlock = movedBlock.getRelative(direction);
                Claim fromClaim = ClaimManager.getClaim(movedBlock.getChunk());
                Claim toClaim = ClaimManager.getClaim(destinationBlock.getChunk());
                if (pistonClaim != null && !this.requiresProtection(fromClaim)) continue;
                if (movedBlock.getChunk().equals((Object)destinationBlock.getChunk())) {
                    if (this.isPistonMoveAllowed(pistonClaim, fromClaim, fromClaim)) continue;
                    event.setCancelled(true);
                    return;
                }
                if (this.isPistonMoveAllowed(pistonClaim, fromClaim, toClaim)) continue;
                event.setCancelled(true);
                return;
            }
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("An SQLException occurred in ClaimPistonMovementListener in onPistonRetract: " + String.valueOf(e));
            event.setCancelled(true);
        }
    }

    private boolean isPistonMoveAllowed(Claim pistonClaim, Claim fromClaim, Claim toClaim) {
        String toOwner;
        String pistonOwner = pistonClaim != null ? pistonClaim.getOwnerId() : null;
        String fromOwner = fromClaim != null ? fromClaim.getOwnerId() : null;
        String string = toOwner = toClaim != null ? toClaim.getOwnerId() : null;
        if (this.requiresProtection(pistonClaim) || this.requiresProtection(fromClaim) || this.requiresProtection(toClaim)) {
            if (!this.equalsOrNull(fromOwner, toOwner)) {
                return false;
            }
            if (!this.equalsOrNull(pistonOwner, toOwner)) {
                return false;
            }
            return this.equalsOrNull(pistonOwner, fromOwner);
        }
        return true;
    }

    private boolean requiresProtection(Claim claim) {
        return claim != null && claim.hasProtection(this.getKey());
    }

    private boolean equalsOrNull(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

