/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.database;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.util.config.ConfigHandler;
import net.mathias2246.buildmc.util.config.ConfigurationValidationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DatabaseConfig
implements ConfigHandler {
    private final File configFile = new File(CoreMain.plugin.getDataFolder(), "database.yml");
    private FileConfiguration config;
    private final Logger logger = CoreMain.plugin.getLogger();
    private static final String USE_SERVER_MODE = "database.useServerMode";
    private static final String SERVER_URL = "database.serverUrl";
    private static final String SERVER_PORT = "database.serverPort";

    @Override
    public void generateConfig() {
        if (!this.configFile.exists()) {
            try {
                InputStream defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("database.yml");
                if (defaultConfigStream == null) {
                    throw new IOException("Default config file not found in resources.");
                }
                if (!this.configFile.getParentFile().exists() && !this.configFile.getParentFile().mkdirs()) {
                    this.logger.warning("Failed to create directories for config file.");
                }
                Files.copy(defaultConfigStream, this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.logger.severe("Error generating config: " + String.valueOf(e));
            }
        }
    }

    @Override
    public void loadConfig() throws IOException {
        if (!this.configFile.exists()) {
            this.generateConfig();
            if (!this.configFile.exists()) {
                throw new IOException("Failed to generate and locate database.yml");
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    @Override
    public <T> T get(String key) {
        return (T)this.config.get(key);
    }

    @Override
    public <T> T get(String key, T defaultValue) {
        return (T)this.config.get(key, defaultValue);
    }

    @Override
    public void set(String key, Object value) {
        this.config.set(key, value);
        this.saveConfig();
    }

    @Override
    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    @Override
    public void validateConfig() throws ConfigurationValidationException {
        if (!this.config.contains(USE_SERVER_MODE)) {
            throw new ConfigurationValidationException("Missing configuration key: database.useServerMode");
        }
        if (!this.config.contains(SERVER_URL)) {
            throw new ConfigurationValidationException("Missing configuration key: database.serverUrl");
        }
        if (!(this.config.get(USE_SERVER_MODE) instanceof Boolean)) {
            throw new ConfigurationValidationException("Invalid value type for key: database.useServerMode. Expected Boolean.");
        }
        if (!(this.config.get(SERVER_URL) instanceof String)) {
            throw new ConfigurationValidationException("Invalid value type for key: database.serverUrl. Expected String.");
        }
        if (!(this.config.get(SERVER_PORT) instanceof Integer)) {
            throw new ConfigurationValidationException("Invalid value type for key: database.serverPort. Expected Integer.");
        }
        String serverUrl = this.config.getString(SERVER_URL);
        if (serverUrl == null || serverUrl.isEmpty()) {
            throw new ConfigurationValidationException("Invalid value for key: database.serverUrl. URL cannot be null or empty.");
        }
    }

    private void saveConfig() {
        if (CoreMain.plugin.getServer().isPrimaryThread()) {
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                this.logger.severe("Could not save config database.yml: " + String.valueOf(e));
            }
        } else {
            CoreMain.plugin.getServer().getScheduler().runTask(CoreMain.plugin, this::saveConfig);
        }
    }

    public boolean isServerMode() {
        return this.get(USE_SERVER_MODE, false);
    }

    public String getServerUrl() {
        return this.get(SERVER_URL, "jdbc:h2:tcp://localhost/./database");
    }

    public int getServerPort() {
        return this.config.getInt(SERVER_PORT, 9092);
    }
}

