/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.endEvent;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.api.endEvent.EndChangeCause;
import net.mathias2246.buildmc.api.endEvent.EndState;
import net.mathias2246.buildmc.api.event.endevent.EndStateChangeEvent;
import net.mathias2246.buildmc.endEvent.EndListener;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class EndEventCommand {
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder() {
        LiteralArgumentBuilder cmd = Commands.literal((String)"endevent");
        cmd.requires(command -> command.getSender().hasPermission("buildmc.admin"));
        cmd.then(this.getSubCommand("open", true));
        cmd.then(this.getSubCommand("close", false));
        return cmd;
    }

    private LiteralArgumentBuilder<CommandSourceStack> getSubCommand(String name, boolean allowEnd) {
        LiteralArgumentBuilder cmd = Commands.literal((String)name);
        cmd.executes(command -> {
            CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
            String openAnnouncementKey = "messages.end-event.broadcast-opened";
            String closeAnnouncementKey = "messages.end-event.broadcast-closed";
            EndState newState = allowEnd ? EndState.OPEN : EndState.CLOSED;
            EndState prevState = EndListener.allowEnd ? EndState.OPEN : EndState.CLOSED;
            String messageKey = allowEnd ? openAnnouncementKey : closeAnnouncementKey;
            EndStateChangeEvent event = new EndStateChangeEvent(newState, prevState, EndChangeCause.COMMAND, sender, messageKey);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return 0;
            }
            messageKey = event.getAnnouncementKey();
            EndListener.allowEnd = allowEnd;
            Main.config.set("end-event.allow-end", (Object)allowEnd);
            try {
                Main.config.save(Main.configFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String senderMessageKey = allowEnd ? "messages.end-event.opened" : "messages.end-event.closed";
            TranslatableComponent senderMessage = Component.translatable(senderMessageKey);
            ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)senderMessage);
            for (Player player : Bukkit.getOnlinePlayers()) {
                TranslatableComponent msg = Component.translatable(messageKey);
                player.sendMessage((Component)msg);
            }
            return 1;
        });
        return cmd;
    }
}

