/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.spawnElytra;

import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.spawnElytra.SpawnBoostRunnable;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.GameMode;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;

public record ElytraListeners(boolean boostEnabled, double multiplyValue) implements Listener
{
    @EventHandler
    public void onDoubleJump(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (!SpawnBoostRunnable.isSurvival(player)) {
            return;
        }
        if (!Main.zoneManager.isInZone(player)) {
            return;
        }
        event.setCancelled(true);
        if (player.isGliding()) {
            return;
        }
        SpawnBoostRunnable.setPlayerFlying(player);
        if (this.boostEnabled && !SpawnBoostRunnable.isPlayerBoosted(player)) {
            player.sendActionBar(Message.msg(player, "messages.spawn-elytra.boost-hint"));
        }
    }

    @EventHandler
    public void onSwapItem(PlayerSwapHandItemsEvent event) {
        if (!this.boostEnabled) {
            return;
        }
        Player player = event.getPlayer();
        if (!SpawnBoostRunnable.isUsingSpawnElytra(player) || SpawnBoostRunnable.isPlayerBoosted(player)) {
            return;
        }
        event.setCancelled(true);
        SpawnBoostRunnable.applyBoost(player, this.multiplyValue, 1.2);
    }

    @EventHandler
    public static void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (SpawnBoostRunnable.isUsingSpawnElytra(player) && (event.getCause() == EntityDamageEvent.DamageCause.FALL || event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public static void onToggleGlide(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (SpawnBoostRunnable.isUsingSpawnElytra(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityMount(EntityMountEvent event) {
        Entity entity = event.getEntity();
        if (SpawnBoostRunnable.isUsingSpawnElytra(entity) && entity instanceof Player) {
            Player player = (Player)entity;
            SpawnBoostRunnable.stopFlying(player);
        }
    }

    @EventHandler
    public void onGamemodeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        GameMode oldMode = player.getGameMode();
        GameMode newMode = event.getNewGameMode();
        if (SpawnBoostRunnable.isSurvival(oldMode) && !SpawnBoostRunnable.isSurvival(newMode) && SpawnBoostRunnable.isUsingSpawnElytra(player)) {
            SpawnBoostRunnable.stopFlying(player);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        player.getScheduler().runAtFixedRate(Main.plugin, task -> {
            if (!SpawnBoostRunnable.isSurvival(player)) {
                return;
            }
            if (SpawnBoostRunnable.isUsingSpawnElytra(player) && !player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir()) {
                SpawnBoostRunnable.stopFlying(player);
            } else if (!player.isGliding()) {
                boolean inZone = Main.zoneManager.isInZone(player);
                player.setAllowFlight(inZone);
            }
        }, null, 1L, 3L);
        if (!Main.config.getBoolean("spawn-elytra.on-join-elytra-check", true)) {
            return;
        }
        SpawnBoostRunnable.stopFlying(player);
        if (SpawnBoostRunnable.isSurvival(player)) {
            player.setAllowFlight(false);
        }
    }
}

