/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredRegistry<T extends Keyed>
implements Registry<T> {
    private final Map<NamespacedKey, T> map = new HashMap<NamespacedKey, T>();
    private boolean isInitialized = false;

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (this.isInitialized) {
            throw new IllegalArgumentException("A registry cannot be initialized twice!");
        }
        this.isInitialized = true;
    }

    public void addEntry(@NotNull T entry) {
        if (this.isInitialized) {
            return;
        }
        this.map.putIfAbsent(entry.getKey(), entry);
    }

    public void removeEntryOrThrow(@NotNull NamespacedKey key) throws IllegalStateException, IllegalArgumentException {
        if (this.isInitialized) {
            throw new IllegalStateException("A registry cannot be changed after being initialized!");
        }
        if (!this.map.containsKey(key)) {
            throw new IllegalArgumentException("A registry cannot be changed after being initialized!");
        }
        this.map.remove(key);
    }

    public void removeEntry(@NotNull NamespacedKey key) {
        if (this.isInitialized) {
            return;
        }
        this.map.remove(key);
    }

    @SafeVarargs
    public final void addEntries(T ... entries) {
        if (this.isInitialized) {
            return;
        }
        for (T e : entries) {
            this.map.putIfAbsent(e.getKey(), e);
        }
    }

    public void addEntryOrThrow(@NotNull T entry) throws IllegalArgumentException, IllegalStateException {
        if (this.isInitialized) {
            throw new IllegalStateException("This Registry is already initialized! You can only change this registry before it is initialized!");
        }
        if (this.map.containsKey(entry.getKey())) {
            throw new IllegalArgumentException("An entry with the same key already exists inside this registry!");
        }
        this.map.put(entry.getKey(), entry);
    }

    @Nullable
    public T get(@NotNull NamespacedKey namespacedKey) {
        return (T)((Keyed)this.map.get(namespacedKey));
    }

    @NotNull
    public T getOrThrow(@NotNull NamespacedKey namespacedKey) throws IllegalArgumentException {
        if (!this.map.containsKey(namespacedKey)) {
            throw new IllegalArgumentException("The given key was not found");
        }
        return (T)((Keyed)this.map.get(namespacedKey));
    }

    @NotNull
    public Optional<T> getOptional(@NotNull NamespacedKey namespacedKey) {
        return Optional.ofNullable((Keyed)this.map.get(namespacedKey));
    }

    @NotNull
    public Optional<T> getOptional(@NotNull String keyString) {
        NamespacedKey key = NamespacedKey.fromString((String)keyString);
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Keyed)this.map.get(key));
    }

    @NotNull
    public Stream<T> stream() {
        return this.map.values().stream();
    }

    @NotNull
    public Stream<NamespacedKey> keyStream() {
        return this.map.keySet().stream();
    }

    @NotNull
    public Iterator<T> iterator() {
        return this.map.values().iterator();
    }
}

